/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

public enum Accuracy {
    EXACT_COUNT,
    BEST_UPPER_BOUND,
    BEST_LOWER_BOUND,
    APPROXIMATION;


    public boolean atLeastAsPreciseAs(Accuracy other) {
        switch (this) {
            case EXACT_COUNT: {
                return true;
            }
            case APPROXIMATION: {
                return APPROXIMATION == other;
            }
            case BEST_UPPER_BOUND: {
                return BEST_UPPER_BOUND == other || APPROXIMATION == other;
            }
            case BEST_LOWER_BOUND: {
                return BEST_LOWER_BOUND == other || APPROXIMATION == other;
            }
        }
        throw new IllegalArgumentException();
    }

    public Accuracy reciprocal() {
        switch (this) {
            case APPROXIMATION: {
                return APPROXIMATION;
            }
            case BEST_UPPER_BOUND: {
                return BEST_LOWER_BOUND;
            }
            case BEST_LOWER_BOUND: {
                return BEST_UPPER_BOUND;
            }
            case EXACT_COUNT: {
                return EXACT_COUNT;
            }
        }
        throw new IllegalArgumentException();
    }
}

