/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.equinox.internal.security.storage.Base64;

public class AES {
    private static final byte[] SALT = new byte[]{-49, 57, -47, -63, -9, -72, 106, 53};
    private static final int PASSWORD_BITS_SIZE = 128;
    private static final int ITERATIONS = 1000;
    private static final int IV_BYTES_SIZE = 16;

    public static String encrypt(String payload, char[] password) throws GeneralSecurityException {
        SecretKey secret = AES.prepareKey(password);
        Cipher pbeCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeCipher.init(1, secret);
        AlgorithmParameters params = pbeCipher.getParameters();
        byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
        if (iv.length != 16) {
            throw new AssertionError((Object)"IV size != 16");
        }
        byte[] unencrypted = payload.getBytes(Charset.forName("UTF-8"));
        byte[] encrypted = pbeCipher.doFinal(unencrypted);
        ByteBuffer data = ByteBuffer.allocate(iv.length + encrypted.length);
        data.put(iv);
        data.put(encrypted);
        return Base64.encode((byte[])data.array());
    }

    public static String decrypt(String encryptedForm, char[] password) throws GeneralSecurityException {
        SecretKey secret = AES.prepareKey(password);
        byte[] decoded = Base64.decode((String)encryptedForm);
        assert (decoded.length > 16);
        IvParameterSpec iv = new IvParameterSpec(decoded, 0, 16);
        Cipher pbeCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeCipher.init(2, (Key)secret, iv);
        byte[] deciphered = pbeCipher.doFinal(decoded, 16, decoded.length - 16);
        return new String(deciphered, Charset.forName("UTF-8"));
    }

    private static SecretKey prepareKey(char[] password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(password, SALT, 1000, 128);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
        return secret;
    }
}

