/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.histogram;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.histogram.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class HistogramDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeXYDataProvider<TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.internal.tmf.core.histogram.HistogramDataProvider";
    static final String TITLE = Objects.requireNonNull(Messages.HistogramDataProvider_Title);
    private static final AtomicLong TRACE_IDS = new AtomicLong();
    private final TmfStatisticsModule fModule;
    private @Nullable TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> fCached = null;
    private final long fTraceId = TRACE_IDS.getAndIncrement();
    private final long fTotalId = TRACE_IDS.getAndIncrement();
    private final long fLostId = TRACE_IDS.getAndIncrement();

    public HistogramDataProvider(ITmfTrace trace, TmfStatisticsModule module) {
        super(trace);
        this.fModule = module;
    }

    @Override
    public TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        if (this.fCached != null) {
            return this.fCached;
        }
        this.fModule.waitForInitialization();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new TmfTreeDataModel(this.fTraceId, -1L, Collections.singletonList(this.getTrace().getName())));
        builder.add((Object)new TmfTreeDataModel(this.fTotalId, this.fTraceId, Collections.singletonList(Objects.requireNonNull(Messages.HistogramDataProvider_Total))));
        ITmfStateSystem eventsSs = Objects.requireNonNull(this.fModule.getStateSystem("org.eclipse.linuxtools.tmf.statistics.types"));
        if (eventsSs.optQuarkAbsolute(new String[]{"lost_events"}) != -2) {
            builder.add((Object)new TmfTreeDataModel(this.fLostId, this.fTraceId, Collections.singletonList(Objects.requireNonNull(Messages.HistogramDataProvider_Lost))));
        }
        if (eventsSs.waitUntilBuilt(0L)) {
            TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> response = new TmfModelResponse<TmfTreeModel<TmfTreeDataModel>>(new TmfTreeModel(Collections.emptyList(), builder.build()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            this.fCached = response;
            return response;
        }
        return new TmfModelResponse<TmfTreeModel<TmfTreeDataModel>>(new TmfTreeModel(Collections.emptyList(), builder.build()), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    @Override
    public @NonNull TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        this.fModule.waitForInitialization();
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        long[] xValues = new long[]{};
        if (filter == null) {
            return TmfXyResponseFactory.create(TITLE, xValues, Collections.emptyList(), true);
        }
        xValues = filter.getTimesRequested();
        Object selected = filter.getSelectedItems();
        int n = xValues.length;
        ImmutableList.Builder builder = ImmutableList.builder();
        ITmfStatistics stats = Objects.requireNonNull(this.fModule.getStatistics());
        if (selected.contains(this.fTotalId)) {
            List<Long> values = stats.histogramQuery(filter.getTimesRequested());
            double[] y = new double[n];
            Arrays.setAll(y, values::get);
            String totalName = String.valueOf(this.getTrace().getName()) + '/' + Messages.HistogramDataProvider_Total;
            builder.add((Object)new YModel(this.fTotalId, totalName, y));
        }
        ITmfStateSystem eventsSs = this.fModule.getStateSystem("org.eclipse.linuxtools.tmf.statistics.types");
        if (selected.contains(this.fLostId) && eventsSs != null) {
            try {
                YModel series = this.getLostEvents(eventsSs, xValues);
                builder.add((Object)series);
            }
            catch (StateSystemDisposedException e) {
                return TmfXyResponseFactory.createFailedResponse(CommonStatusMessage.STATE_SYSTEM_FAILED);
            }
        }
        boolean completed = eventsSs != null ? eventsSs.waitUntilBuilt(0L) || eventsSs.getCurrentEndTime() >= filter.getEnd() : false;
        return TmfXyResponseFactory.create(TITLE, xValues, (Collection<IYModel>)builder.build(), completed);
    }

    private YModel getLostEvents(ITmfStateSystem ss, long[] times) throws StateSystemDisposedException {
        int leEndQuark = ss.optQuarkAbsolute(new String[]{"lost_events"});
        int leCountQuark = ss.optQuarkAbsolute(new String[]{"event_types", "Lost event"});
        long step = (times[times.length - 1] - times[0]) / (long)times.length;
        long lastTime = times[times.length - 1];
        long firstTime = times[0];
        double[] leY = new double[times.length];
        long t = firstTime;
        if (ss.getStartTime() <= t) {
            ArrayList sortedEndIntervals = Lists.newArrayList((Iterable)ss.query2D(Collections.singleton(leEndQuark), firstTime, lastTime));
            sortedEndIntervals.sort(Comparator.comparing(ITmfStateInterval::getStartTime));
            ArrayList sortedCountIntervals = Lists.newArrayList((Iterable)ss.query2D(Collections.singleton(leCountQuark), firstTime, lastTime));
            sortedCountIntervals.sort(Comparator.comparing(ITmfStateInterval::getStartTime));
            Iterator endTimeIter = sortedEndIntervals.iterator();
            ArrayList<LostEventInterval> lostEventIntervals = new ArrayList<LostEventInterval>();
            ITmfStateInterval endTimeInterval = (ITmfStateInterval)endTimeIter.next();
            for (ITmfStateInterval lostCountInterval : sortedCountIntervals) {
                while (!endTimeInterval.intersects(lostCountInterval.getStartTime())) {
                    if (!endTimeIter.hasNext()) {
                        throw new IllegalStateException();
                    }
                    endTimeInterval = (ITmfStateInterval)endTimeIter.next();
                }
                Object endTime = endTimeInterval.getValue();
                Object lostCount = lostCountInterval.getValue();
                if (!(endTime instanceof Number) || !(lostCount instanceof Number)) continue;
                lostEventIntervals.add(new LostEventInterval(endTimeInterval.getStartTime(), ((Number)endTime).longValue(), ((Number)lostCount).longValue()));
            }
            int i = 0;
            while (i < times.length - 2) {
                boolean intersect = false;
                int intervalIndex = 0;
                while (intervalIndex < lostEventIntervals.size()) {
                    if (((LostEventInterval)lostEventIntervals.get(intervalIndex)).intersects(times[i], times[i + 1])) {
                        intersect = true;
                        break;
                    }
                    ++intervalIndex;
                }
                if (intersect) {
                    long lostEventCount;
                    double yValue;
                    LostEventInterval lostEventInterval = (LostEventInterval)lostEventIntervals.get(intervalIndex);
                    long prevCount = 0L;
                    if (intervalIndex - 1 >= 0) {
                        prevCount = ((LostEventInterval)lostEventIntervals.get(intervalIndex - 1)).getLostEventCount();
                    }
                    if ((yValue = (double)step * (double)((lostEventCount = lostEventInterval.getLostEventCount()) - prevCount) / (double)(lostEventInterval.getEndTime() - lostEventInterval.getStartTime())) > (double)lostEventCount) {
                        yValue = (double)lostEventCount - (double)prevCount;
                    }
                    leY[i] = yValue;
                }
                ++i;
            }
        }
        String lostName = String.valueOf(this.getTrace().getName()) + '/' + Messages.HistogramDataProvider_Lost;
        return new YModel(this.fLostId, lostName, leY);
    }

    @Override
    public String getId() {
        return ID;
    }

    private class LostEventInterval {
        private final long fStartTime;
        private final long fEndTime;
        private final long fLostEventCount;

        public LostEventInterval(long startTime, long endTime, long lostEventCount) {
            this.fStartTime = startTime;
            this.fEndTime = endTime;
            this.fLostEventCount = lostEventCount;
        }

        public long getEndTime() {
            return this.fEndTime;
        }

        public long getStartTime() {
            return this.fStartTime;
        }

        public long getLostEventCount() {
            return this.fLostEventCount;
        }

        public boolean intersects(long start, long end) {
            return start <= this.fEndTime && end >= this.fStartTime;
        }
    }
}

