/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.ecl.TeslaErrorStatus;

public class ExecutionStatus
extends MultiStatus {
    private int line = -1;
    private int column = -1;
    private int length = -1;
    private IQ7NamedElement element;
    private AdvancedInformation info;
    private static final Predicate<IStatus> IS_FAILED = new Predicate<IStatus>(){

        public boolean apply(IStatus input) {
            return !input.isOK();
        }
    };

    public ExecutionStatus(IStatus status) {
        super(status.getPlugin(), status.getCode(), new IStatus[]{status}, status.getMessage(), status.getException());
        Object ss;
        if (status instanceof ScriptErrorStatus) {
            ss = (ScriptErrorStatus)status;
            this.line = ss.getLine();
            this.column = ss.getColumn();
            this.length = ss.getLength();
        }
        if (status instanceof ExecutionStatus) {
            ss = (ExecutionStatus)status;
            this.line = ((ExecutionStatus)((Object)ss)).getLine();
            this.column = ((ExecutionStatus)((Object)ss)).getColumn();
            this.length = ((ExecutionStatus)((Object)ss)).getLength();
        }
    }

    public ExecutionStatus(int severity, String pluginId, String message) {
        super(pluginId, 0, message, null);
        this.setSeverity(severity);
    }

    public ExecutionStatus(int severity, String pluginId, int line, int column, int length) {
        super(pluginId, 0, String.format("Execution failed on line %d at column %d", line, column), null);
        this.setSeverity(severity);
        this.line = line;
        this.column = column;
        this.length = length;
    }

    public boolean hasLocation() {
        return this.line > 0 && this.column > 0 && this.length > 0;
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    private void updateMessage() {
        if (this.getMessage().matches(".*Execution failed on line (\\d+) at column (\\d+).*")) {
            this.setMessage(this.getMessage().replaceFirst("Execution failed on line (\\d+) at column (\\d+)", String.format("Execution failed on line %d at column %d", this.line, this.column)));
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public IStatus getCause() {
        return this.getCause(false);
    }

    public IStatus getCause(boolean flatten) {
        IStatus cause = (IStatus)Iterables.tryFind(Arrays.asList(this.getChildren()), IS_FAILED).orNull();
        if (flatten && cause instanceof ExecutionStatus) {
            return ((ExecutionStatus)cause).getCause(flatten);
        }
        return cause;
    }

    public void setAdvancedInfo(AdvancedInformation info) {
        this.info = info;
    }

    public AdvancedInformation getInfo() {
        if (this.info != null) {
            return this.info;
        }
        TeslaErrorStatus status = ExecutionStatus.extractTeslaStatus(this);
        return status == null ? null : status.getInfo();
    }

    private static TeslaErrorStatus extractTeslaStatus(ExecutionStatus status) {
        if (status.getCause() instanceof TeslaErrorStatus) {
            return (TeslaErrorStatus)status.getCause();
        }
        if (status.getCause() instanceof ScriptErrorStatus) {
            return ExecutionStatus.extractTeslaStatus((ScriptErrorStatus)status.getCause());
        }
        return null;
    }

    private static TeslaErrorStatus extractTeslaStatus(ScriptErrorStatus status) {
        if (status.getCause() instanceof TeslaErrorStatus) {
            return (TeslaErrorStatus)status.getCause();
        }
        if (status.getCause() instanceof ScriptErrorStatus) {
            return ExecutionStatus.extractTeslaStatus((ScriptErrorStatus)status.getCause());
        }
        return null;
    }

    public IQ7NamedElement getElement() {
        return this.element;
    }

    public void setElement(IQ7NamedElement element) {
        this.element = element;
    }

    public void updateLine(int actualLine) {
        this.setLine(actualLine);
        this.updateMessage();
    }
}

