/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.editor;

import java.util.ArrayList;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.m2e.pde.target.BNDInstructions;
import org.eclipse.m2e.pde.target.MavenTargetBundle;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.m2e.pde.target.MissingMetadataMode;
import org.eclipse.m2e.pde.ui.target.editor.MavenArtifactInstructionsWizard;
import org.eclipse.m2e.pde.ui.target.editor.MavenTargetLocationWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.ui.target.ITargetLocationHandler;

public class MavenTargetLocationEditor
implements ITargetLocationHandler {
    public boolean canEdit(ITargetDefinition target, TreePath treePath) {
        Object root = treePath.getFirstSegment();
        if (root instanceof MavenTargetLocation var4_5) {
            if (treePath.getSegmentCount() == 1) {
                return true;
            }
            Object lastSegment = treePath.getLastSegment();
            if (lastSegment instanceof MavenTargetDependency) {
                return true;
            }
            if (location.getMetadataMode() == MissingMetadataMode.GENERATE) {
                if (lastSegment instanceof DependencyNode var7_8) {
                    MavenTargetBundle bundle = location.getMavenTargetBundle(node.getArtifact());
                    return bundle != null && bundle.isWrapped();
                }
                if (lastSegment instanceof MavenTargetDependency bundle) {
                    MavenTargetBundle bundle = location.getMavenTargetBundle((MavenTargetDependency)dependency);
                    return bundle != null && bundle.isWrapped();
                }
            }
        }
        return false;
    }

    public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
        Object root = treePath.getFirstSegment();
        if (root instanceof MavenTargetLocation var4_5) {
            if (treePath.getSegmentCount() == 1) {
                MavenTargetLocationWizard wizard = new MavenTargetLocationWizard((MavenTargetLocation)location);
                wizard.setTarget(target);
                return wizard;
            }
            Object lastSegment = treePath.getLastSegment();
            if (lastSegment instanceof MavenTargetDependency var7_9) {
                MavenTargetLocationWizard wizard = new MavenTargetLocationWizard((MavenTargetLocation)location);
                wizard.setTarget(target);
                wizard.setSelectedRoot((MavenTargetDependency)selectedRoot);
                return wizard;
            }
            if (lastSegment instanceof DependencyNode wizard) {
                return this.edit(target, (MavenTargetLocation)location, node.getArtifact());
            }
            if (lastSegment instanceof MavenTargetDependency var11_14 && (bundle = location.getMavenTargetBundle((MavenTargetDependency)dependency)) != null) {
                return this.edit(target, (MavenTargetLocation)location, bundle.getArtifact());
            }
        }
        return null;
    }

    private IWizard edit(final ITargetDefinition target, final MavenTargetLocation location, Artifact artifact) {
        BNDInstructions instructions = location.getInstructions(artifact);
        MavenArtifactInstructionsWizard wizard = new MavenArtifactInstructionsWizard(instructions){

            @Override
            public boolean performFinish() {
                boolean finish = super.performFinish();
                if (finish) {
                    BNDInstructions instructions = this.getInstructions();
                    ArrayList<BNDInstructions> updatedInstructions = new ArrayList<BNDInstructions>();
                    updatedInstructions.add(instructions);
                    for (BNDInstructions existing : location.getInstructions()) {
                        if (existing.getKey().equals(instructions.getKey())) continue;
                        updatedInstructions.add(instructions);
                    }
                    MavenTargetLocation update = location.withInstructions(updatedInstructions);
                    ITargetLocation[] locations = target.getTargetLocations();
                    int i = 0;
                    while (i < locations.length) {
                        if (locations[i] == location) {
                            locations[i] = update;
                            break;
                        }
                        ++i;
                    }
                    target.setTargetLocations(locations);
                }
                return finish;
            }
        };
        wizard.setWindowTitle(String.valueOf(wizard.getWindowTitle()) + " [" + artifact + "]");
        return wizard;
    }

    public boolean canUpdate(ITargetDefinition target, TreePath treePath) {
        return treePath.getFirstSegment() instanceof MavenTargetLocation;
    }

    public IStatus update(ITargetDefinition target, TreePath[] treePaths, IProgressMonitor monitor) {
        ITargetLocation[] targetLocations = target.getTargetLocations();
        Status status = new Status(0, "org.eclipse.m2e.pde.ui", 101, "", null);
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object segment = treePath.getFirstSegment();
            if (segment instanceof MavenTargetLocation var11_11) {
                try {
                    MavenTargetLocation update = targetLocation.update(monitor);
                    if (update != null) {
                        int i = 0;
                        while (i < targetLocations.length) {
                            if (targetLocations[i] == targetLocation) {
                                targetLocations[i] = update;
                                break;
                            }
                            ++i;
                        }
                        target.setTargetLocations(targetLocations);
                        status = Status.OK_STATUS;
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
            ++n2;
        }
        return status;
    }

    public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
        ITargetLocation[] iTargetLocationArray = targetLocations;
        int n = targetLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation location = iTargetLocationArray[n2];
            if (location instanceof MavenTargetLocation var8_8) {
                mavenLocation.refresh();
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public boolean canDisable(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getFirstSegment();
        if (segment instanceof MavenTargetLocation var4_5 && ( instanceOfPatternExpressionValue = (lastSegment = treePath.getLastSegment())) instanceof DependencyNode && (var7_8 = (DependencyNode) instanceOfPatternExpressionValue) == (DependencyNode) instanceOfPatternExpressionValue) {
            return !location.isExcluded(node.getArtifact());
        }
        return false;
    }

    public boolean canEnable(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getFirstSegment();
        if (segment instanceof MavenTargetLocation var4_5 && ( instanceOfPatternExpressionValue = (lastSegment = treePath.getLastSegment())) instanceof DependencyNode && (var7_8 = (DependencyNode) instanceOfPatternExpressionValue) == (DependencyNode) instanceOfPatternExpressionValue) {
            return location.isExcluded(node.getArtifact());
        }
        return false;
    }

    public boolean canRemove(ITargetDefinition target, TreePath treePath) {
        Object lastSegment;
        Object segment = treePath.getFirstSegment();
        return segment instanceof MavenTargetLocation && (lastSegment = treePath.getLastSegment()) instanceof MavenTargetDependency;
    }

    public IStatus remove(ITargetDefinition target, TreePath[] treePaths) {
        ITargetLocation[] targetLocations = target.getTargetLocations();
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object segment = treePath.getFirstSegment();
            if (segment instanceof MavenTargetLocation var9_9 && ( instanceOfPatternExpressionValue = (lastSegment = treePath.getLastSegment())) instanceof MavenTargetDependency && (var12_12 = (MavenTargetDependency) instanceOfPatternExpressionValue) == (MavenTargetDependency) instanceOfPatternExpressionValue) {
                int i = 0;
                while (i < targetLocations.length) {
                    ITargetLocation location = targetLocations[i];
                    if (location == mavenTargetLocation) {
                        targetLocations[i] = mavenTargetLocation.withoutRoot((MavenTargetDependency)mavenTargetDependency);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        target.setTargetLocations(targetLocations);
        return Status.OK_STATUS;
    }

    public IStatus toggle(ITargetDefinition target, TreePath[] treePaths) {
        int toggled = 0;
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object segment = treePath.getFirstSegment();
            if (segment instanceof MavenTargetLocation var9_9 && ( instanceOfPatternExpressionValue = (lastSegment = treePath.getLastSegment())) instanceof DependencyNode && (var12_12 = (DependencyNode) instanceOfPatternExpressionValue) == (DependencyNode) instanceOfPatternExpressionValue) {
                location.setExcluded(node.getArtifact(), !location.isExcluded(node.getArtifact()));
                target.setTargetLocations(target.getTargetLocations());
                ++toggled;
            }
            ++n2;
        }
        return toggled > 0 ? new Status(0, "org.eclipse.m2e.pde.ui", 102, "", null) : Status.CANCEL_STATUS;
    }
}

