/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProject;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.linuxtools.rpm.core.utils.BufferedProcessInputStream;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.FrameworkUtil;

public class Createrepo {
    private static final String[] DEFAULT_ARGUMENTS = new String[]{"verbose"};
    private List<String> commandSwitches = new ArrayList<String>();

    public Createrepo() {
        this.commandSwitches.add("createrepo");
        String[] stringArray = DEFAULT_ARGUMENTS;
        int n = DEFAULT_ARGUMENTS.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.commandSwitches.add("--".concat(arg));
            ++n2;
        }
    }

    public IStatus execute(OutputStream os, CreaterepoProject project, List<String> commands) {
        IStatus validVersion = Createrepo.isCorrectVersion();
        if (!validVersion.isOK()) {
            return validVersion;
        }
        this.commandSwitches.addAll(commands);
        this.commandSwitches.add(project.getContentFolder().getLocation().toOSString());
        String commandString = "";
        for (String arg : this.commandSwitches) {
            commandString = commandString.concat(String.valueOf(arg) + " ");
        }
        commandString = commandString.concat("\n");
        try {
            os.write(commandString.getBytes());
            return Utils.runCommand((OutputStream)os, (IProject)project.getProject(), (String[])this.commandSwitches.toArray(new String[this.commandSwitches.size()]));
        }
        catch (IOException e) {
            return Status.error((String)NLS.bind((String)Messages.Createrepo_errorExecuting, (Object)commandString), (Throwable)e);
        }
    }

    public static IStatus checkIfAvailable() {
        try {
            BufferedProcessInputStream bpis = Utils.runCommandToInputStream((String[])new String[]{"which", "createrepo"});
            if (bpis.getExitValue() == 1) {
                return Status.error((String)Messages.Createrepo_errorCommandNotFound);
            }
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return Status.warning((String)Messages.Createrepo_errorTryingToFindCommand, (Throwable)e);
        }
        catch (InterruptedException e) {
            return new Status(8, FrameworkUtil.getBundle(CreaterepoProject.class).getSymbolicName(), Messages.Createrepo_jobCancelled, (Throwable)e);
        }
    }

    public static IStatus isCorrectVersion() {
        IStatus available = Createrepo.checkIfAvailable();
        if (!available.isOK()) {
            return available;
        }
        String CREATEREPO_VALID_VERSION = "0.9.8";
        String createrepoVersion = "";
        try {
            boolean createrepoValid;
            String repoOutput = Utils.runCommandToString((String[])new String[]{"createrepo", "--version"}).trim();
            String[] createrepoTemp = repoOutput.split(" ");
            if (createrepoTemp.length > 1) {
                createrepoVersion = createrepoTemp[1];
            }
            if (!(createrepoValid = Createrepo.isGreaterOrEqual(createrepoVersion.split("\\."), "0.9.8".split("\\.")))) {
                return Status.error((String)NLS.bind((String)Messages.Createrepo_errorWrongVersionCreaterepo, (Object[])new String[]{"0.9.8", createrepoVersion}));
            }
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(8, FrameworkUtil.getBundle(CreaterepoProject.class).getSymbolicName(), Messages.Createrepo_errorCancelled, (Throwable)e);
        }
    }

    private static boolean isGreaterOrEqual(String[] current, String[] minimum) {
        if (current.length > 0) {
            int iMinimum;
            int iCurrent;
            block5: {
                try {
                    iCurrent = Integer.parseInt(current[0]);
                    int n = iMinimum = minimum.length == 0 ? 0 : Integer.parseInt(minimum[0]);
                    if (iCurrent <= iMinimum && (current.length != 1 || iCurrent != iMinimum)) break block5;
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (iCurrent == iMinimum && current.length > 1) {
                return Createrepo.isGreaterOrEqual(Arrays.copyOfRange(current, 1, current.length), Arrays.copyOfRange(minimum, 1, minimum.length));
            }
            return false;
        }
        return false;
    }
}

