/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttrConverter;
import org.eclipse.jpt.jpa.annotate.mapping.EntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.GeneratedValueAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.IdEntityPropertyElement;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.DbColumnAnnotationCtl;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IdAnnotationDialog
extends Dialog {
    private ResourceManager resourceManager;
    private EntityPropertyElem entityProp;
    private Table table;
    private IProject project;
    private Text propNameText;
    private Text propTypeText;
    private Combo genStrategyCombo;
    private DbColumnAnnotationCtl columnGroupCtl;

    public IdAnnotationDialog(Shell parentShell, ResourceManager resourceManager, Table table, EntityPropertyElem entityProp, IProject project) {
        super(parentShell);
        this.resourceManager = resourceManager;
        this.table = table;
        this.entityProp = entityProp;
        this.project = project;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(JptJpaUiMakePersistentMessages.ID_ANNOTATION_DLG_TITLE);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 10;
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.widthHint = 400;
        composite.setLayoutData((Object)gd);
        this.createIdGroup(composite);
        this.columnGroupCtl = new DbColumnAnnotationCtl(this.resourceManager, this.entityProp, this.table, this.project);
        this.columnGroupCtl.createColumnGroup(composite, 0);
        this.initFields();
        this.addListeners();
        return composite;
    }

    private Group createIdGroup(Composite parent) {
        Group idGroup = new Group(parent, 0);
        idGroup.setText(JptJpaUiMakePersistentMessages.ID_ANNOTATION_GROUP_DESC);
        GridLayout layout = new GridLayout(2, false);
        idGroup.setLayout((Layout)layout);
        idGroup.setLayoutData((Object)new GridData(768));
        AssociationAnnotationWizard.createLabel((Composite)idGroup, 1, JptJpaUiMakePersistentMessages.PROPERTY_NAME_LABEL, -1);
        this.propNameText = AssociationAnnotationWizard.createText((Composite)idGroup, 1, true, null, 2056);
        AssociationAnnotationWizard.createLabel((Composite)idGroup, 1, JptJpaUiMakePersistentMessages.PROPERTY_TYPE_LABEL, -1);
        this.propTypeText = AssociationAnnotationWizard.createText((Composite)idGroup, 1, true, null, 2056);
        AssociationAnnotationWizard.createLabel((Composite)idGroup, 1, JptJpaUiMakePersistentMessages.GENERATION_STRATEGY, -1);
        this.genStrategyCombo = AssociationAnnotationWizard.createCombo((Composite)idGroup, true, 1, 2060, -1);
        return idGroup;
    }

    private void initFields() {
        String strategy;
        this.propNameText.setText(this.entityProp.getPropertyName());
        this.propTypeText.setText(this.entityProp.getPropertyType());
        String[] strategies = AnnotationAttrConverter.getTagEnumStringValues((String)"generation-stragegy");
        this.genStrategyCombo.setItems(strategies);
        assert (this.entityProp instanceof IdEntityPropertyElement);
        IdEntityPropertyElement idProp = (IdEntityPropertyElement)this.entityProp;
        GeneratedValueAttributes genAttrs = idProp.getGeneratedValueAttrs();
        if (genAttrs != null && (strategy = genAttrs.getStrategy()) != null) {
            int index = this.genStrategyCombo.indexOf(strategy);
            assert (index != -1);
            this.genStrategyCombo.select(index);
        }
        this.columnGroupCtl.initFields();
    }

    private void addListeners() {
        this.genStrategyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IdAnnotationDialog.this.handleGenStrategyChange();
            }
        });
        this.columnGroupCtl.addListeners();
    }

    private void handleGenStrategyChange() {
        String newStrategy = this.genStrategyCombo.getItem(this.genStrategyCombo.getSelectionIndex());
        assert (this.entityProp instanceof IdEntityPropertyElement);
        IdEntityPropertyElement idProp = (IdEntityPropertyElement)this.entityProp;
        GeneratedValueAttributes genAttrs = idProp.getGeneratedValueAttrs();
        if (genAttrs == null) {
            genAttrs = new GeneratedValueAttributes();
            genAttrs.setStrategy(newStrategy);
            idProp.setGeneratedValueAttrs(genAttrs);
        } else {
            genAttrs.setStrategy(newStrategy);
        }
    }
}

