/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.AbstractRepositoryPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.MasterRepositoryController;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Composite;

public class RepositoryRemotePage
extends AbstractRepositoryPage {
    private MasterRepositoryController controller;

    public RepositoryRemotePage() {
        super("remote", "Remote Repository");
        this.setTitle("New Remote Repository");
        this.setMessage("Enter label and connection parameters of the new remote location.");
    }

    @Override
    public IPasswordCredentials getCredentials() {
        return this.controller.getCredentials();
    }

    @Override
    protected void fillPage(Composite container) {
        this.controller = new MasterRepositoryController(container){

            @Override
            protected void validateController() {
                super.validateController();
                if (RepositoryRemotePage.this.controller != null) {
                    RepositoryRemotePage.this.validate();
                } else {
                    UIUtil.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RepositoryRemotePage.this.validate();
                        }
                    });
                }
            }
        };
    }

    @Override
    protected void doValidate(Properties properties) throws Exception {
        CDORepository.IDGeneration idGeneration;
        super.doValidate(properties);
        String connectorDescription = this.controller.getConnectorDescription();
        if (StringUtil.isEmpty((String)connectorDescription)) {
            throw new Exception("Host is empty.");
        }
        String repositoryName = this.controller.getRepositoryName();
        if (StringUtil.isEmpty((String)repositoryName)) {
            throw new CheckoutWizardPage.ValidationProblem("Repository name is empty.");
        }
        properties.setProperty("connectorType", "tcp");
        properties.setProperty("connectorDescription", connectorDescription);
        properties.setProperty("authenticating", Boolean.toString(this.controller.isAuthenticating()));
        properties.setProperty("name", repositoryName);
        CDORepository.VersioningMode versioningMode = this.controller.getVersioningMode();
        if (versioningMode != null) {
            properties.setProperty("versioningMode", versioningMode.toString());
        }
        if ((idGeneration = this.controller.getIDGeneration()) != null) {
            properties.setProperty("idGeneration", idGeneration.toString());
        }
    }
}

