/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongIntToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;

public abstract class AbstractSynchronizedIntCollection
implements MutableIntCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableIntCollection collection;

    protected AbstractSynchronizedIntCollection(MutableIntCollection collection) {
        this(collection, null);
    }

    protected AbstractSynchronizedIntCollection(MutableIntCollection collection, Object newLock) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot create a AbstractSynchronizedIntCollection on a null collection");
        }
        this.collection = collection;
        this.lock = newLock == null ? this : newLock;
    }

    protected Object getLock() {
        return this.lock;
    }

    protected MutableIntCollection getIntCollection() {
        return this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntCollection select(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntCollection reject(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collect((IntToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntCollection with(int element) {
        Object object = this.lock;
        synchronized (object) {
            this.add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntCollection without(int element) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntCollection withAll(IntIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.addAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntCollection withoutAll(IntIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableIntCollection asUnmodifiable() {
        return new UnmodifiableIntCollection(this);
    }

    @Override
    public MutableIntCollection asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableIntCollection toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toImmutable();
        }
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAny(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAny(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAny(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAny(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsNone(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsNone(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsNone(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsNone(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(int newItem) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.add(newItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeIf(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(source);
        }
    }

    @Override
    public MutableIntIterator intIterator() {
        return this.collection.intIterator();
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(IntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int max() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int min() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int minIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int maxIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toArray(int[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reduce(LongIntToLongFunction accumulator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reduce(accumulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reduceIfEmpty(LongIntToLongFunction accumulator, long defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reduceIfEmpty(accumulator, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<IntIterable> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.chunk(size);
        }
    }
}

