/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration;

import java.util.AbstractMap;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterActionAndIndent;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TabSpacesInfo;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.eclipse.tm4e.ui.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeInfo;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class LanguageConfigurationAutoEditStrategy
implements IAutoEditStrategy {
    private IDocument document;
    private IContentType[] contentTypes;
    private TabSpacesInfo tabSpacesInfo;
    private ITextViewer viewer;

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        IContentType[] contentTypes = this.findContentTypes(document);
        if (contentTypes == null || command.text.isEmpty()) {
            return;
        }
        this.installViewer();
        if (TextUtils.isEnter(document, command)) {
            this.onEnter(document, command);
            return;
        }
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType2 = iContentTypeArray[n2];
            CharacterPair autoClosingPair = registry.getAutoClosePair(document.get(), command.offset, command.text, contentType2);
            if (autoClosingPair != null) {
                command.caretOffset = command.offset + command.text.length();
                command.shiftsCaret = false;
                command.text = command.text.equals(autoClosingPair.getKey()) && LanguageConfigurationAutoEditStrategy.isFollowedBy(document, command.offset, (String)autoClosingPair.getKey()) ? "" : (command.text.equals(autoClosingPair.getValue()) && LanguageConfigurationAutoEditStrategy.isFollowedBy(document, command.offset, (String)autoClosingPair.getValue()) ? "" : String.valueOf(command.text) + (String)autoClosingPair.getValue());
                return;
            }
            ++n2;
        }
        Arrays.stream(contentTypes).flatMap(contentType -> registry.getEnabledAutoClosingPairs((IContentType)contentType).stream()).map(AbstractMap.SimpleEntry::getValue).filter(command.text::equals).filter(closing -> LanguageConfigurationAutoEditStrategy.isFollowedBy(document, documentCommand.offset, closing)).findFirst().ifPresent(closing -> {
            documentCommand.caretOffset = documentCommand.offset + documentCommand.text.length();
            documentCommand.shiftsCaret = false;
            documentCommand.text = "";
        });
    }

    private static boolean isFollowedBy(IDocument document, int offset, String value) {
        int i = 0;
        while (i < value.length()) {
            if (document.getLength() <= offset) {
                return false;
            }
            try {
                if (document.getChar(offset) != value.charAt(i)) {
                    return false;
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            ++offset;
            ++i;
        }
        return true;
    }

    private void onEnter(IDocument document, DocumentCommand command) {
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        IContentType[] iContentTypeArray = this.contentTypes;
        int n = this.contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EnterActionAndIndent r;
            IContentType contentType = iContentTypeArray[n2];
            if (registry.shouldEnterAction(document, command.offset, contentType) && (r = registry.getEnterAction(document, command.offset, contentType)) != null) {
                EnterAction enterAction = r.getEnterAction();
                String indentation = TextUtils.getIndentationFromWhitespace(r.getIndentation(), this.getTabSpaces());
                String delim = command.text;
                switch (enterAction.getIndentAction()) {
                    case None: {
                        String typeText;
                        String increasedIndent = this.normalizeIndentation(String.valueOf(indentation) + enterAction.getAppendText());
                        command.text = typeText = String.valueOf(delim) + increasedIndent;
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                        break;
                    }
                    case Indent: {
                        String typeText;
                        String increasedIndent = this.normalizeIndentation(String.valueOf(indentation) + enterAction.getAppendText());
                        command.text = typeText = String.valueOf(delim) + increasedIndent;
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                        break;
                    }
                    case IndentOutdent: {
                        String typeText;
                        String normalIndent = this.normalizeIndentation(indentation);
                        String increasedIndent = this.normalizeIndentation(String.valueOf(indentation) + enterAction.getAppendText());
                        command.text = typeText = String.valueOf(delim) + increasedIndent + delim + normalIndent;
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                        break;
                    }
                    case Outdent: {
                        String outdentedText = this.outdentString(this.normalizeIndentation(String.valueOf(indentation) + enterAction.getAppendText()));
                        command.text = String.valueOf(delim) + outdentedText;
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + (String.valueOf(delim) + outdentedText).length();
                    }
                }
                return;
            }
            ++n2;
        }
        new DefaultIndentLineAutoEditStrategy().customizeDocumentCommand(document, command);
    }

    private IContentType[] findContentTypes(IDocument document) {
        if (this.document != null && this.document.equals(document)) {
            return this.contentTypes;
        }
        try {
            ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)document);
            this.contentTypes = info.getContentTypes();
            this.document = document;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.contentTypes;
    }

    private String outdentString(String str) {
        if (str.startsWith("\t")) {
            return str.substring(1);
        }
        TabSpacesInfo tabSpaces = this.getTabSpaces();
        if (tabSpaces.isInsertSpaces()) {
            char[] chars = new char[tabSpaces.getTabSize()];
            Arrays.fill(chars, ' ');
            String spaces = new String(chars);
            if (str.startsWith(spaces)) {
                return str.substring(spaces.length());
            }
        }
        return str;
    }

    private String normalizeIndentation(String str) {
        TabSpacesInfo tabSpaces = this.getTabSpaces();
        return TextUtils.normalizeIndentation(str, tabSpaces.getTabSize(), tabSpaces.isInsertSpaces());
    }

    private TabSpacesInfo getTabSpaces() {
        if (this.tabSpacesInfo != null) {
            return this.tabSpacesInfo;
        }
        this.tabSpacesInfo = TextUtils.getTabSpaces(this.viewer);
        return this.tabSpacesInfo;
    }

    private void installViewer() {
        if (this.viewer == null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editorPart = page.getActiveEditor();
            this.viewer = (ITextViewer)editorPart.getAdapter(ITextViewer.class);
        }
    }
}

