/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.jsoncdb.core.participant;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.jsoncdb.core.participant.IArglet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class Arglets {
    private static final String EMPTY_STR = "";
    private static final String REGEX_MACRO_NAME = "([\\w$]+)(?:\\([\\w$, ]*?\\))?";
    private static final String REGEX_MACRO_NAME_SKIP_LEADING_WS = "\\s*([\\w$]+)(?:\\([\\w$, ]*?\\))?";
    private static final String REGEX_MACRO_ARG_QUOTED__SKIP_LEADING_WS = "\\s*([\"'])([\\w$]+)(?:\\([\\w$, ]*?\\))?";
    private static final String REGEX_INCLUDEPATH_QUOTED_DIR = "\\s*([\"'])(.+?)\\1";
    private static final String REGEX_INCLUDEPATH_UNQUOTED_DIR = "\\s*([^\\s]+)";

    private Arglets() {
    }

    @Deprecated
    public static abstract class BuiltinDetctionArgsGeneric {
        protected int processArgument(IArglet.IArgumentCollector resultCollector, String argsLine, Matcher[] optionMatchers) {
            throw new IllegalStateException("This class is deprecated - extend class BuiltinDetectionArgsGeneric instead");
        }
    }

    public static abstract class BuiltinDetectionArgsGeneric
    extends BuiltinDetctionArgsGeneric {
        @Override
        protected final int processArgument(IArglet.IArgumentCollector resultCollector, String argsLine, Matcher[] optionMatchers) {
            Matcher[] matcherArray = optionMatchers;
            int n = optionMatchers.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher = matcherArray[n2];
                matcher.reset(argsLine);
                if (matcher.lookingAt()) {
                    resultCollector.addBuiltinDetectionArgument(matcher.group());
                    return matcher.end();
                }
                ++n2;
            }
            return 0;
        }
    }

    public static abstract class IncludeFileGeneric {
        protected final int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine, NameOptionMatcher[] optionMatchers) {
            NameOptionMatcher[] nameOptionMatcherArray = optionMatchers;
            int n = optionMatchers.length;
            int n2 = 0;
            while (n2 < n) {
                NameOptionMatcher oMatcher = nameOptionMatcherArray[n2];
                Matcher matcher = oMatcher.pattern.matcher(argsLine);
                if (matcher.lookingAt()) {
                    String name = matcher.group(oMatcher.nameGroup);
                    resultCollector.addIncludeFile(name);
                    int end = matcher.end();
                    return end;
                }
                ++n2;
            }
            return 0;
        }
    }

    public static class IncludeFile_GCC
    extends IncludeFileGeneric
    implements IArglet {
        private static final NameOptionMatcher[] optionMatchers = new NameOptionMatcher[]{new NameOptionMatcher("-include\\s*([\"'])(.+?)\\1", 2), new NameOptionMatcher("-include\\s*([^\\s]+)", 1)};

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(resultCollector, cwd, argsLine, optionMatchers);
        }
    }

    public static abstract class IncludePathGeneric {
        protected final int processArgument(boolean isSystemIncludePath, IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine, NameOptionMatcher[] optionMatchers) {
            NameOptionMatcher[] nameOptionMatcherArray = optionMatchers;
            int n = optionMatchers.length;
            int n2 = 0;
            while (n2 < n) {
                NameOptionMatcher oMatcher = nameOptionMatcherArray[n2];
                Matcher matcher = oMatcher.pattern.matcher(argsLine);
                if (matcher.lookingAt()) {
                    String name = matcher.group(oMatcher.nameGroup);
                    IPath path = Path.fromOSString((String)name);
                    if (!path.isAbsolute()) {
                        name = cwd.append(path).toOSString();
                    }
                    if (isSystemIncludePath) {
                        resultCollector.addSystemIncludePath(name);
                    } else {
                        resultCollector.addIncludePath(name);
                    }
                    int end = matcher.end();
                    return end;
                }
                ++n2;
            }
            return 0;
        }
    }

    public static class IncludePath_C_POSIX
    extends IncludePathGeneric
    implements IArglet {
        private static final NameOptionMatcher[] optionMatchers = new NameOptionMatcher[]{new NameOptionMatcher("-I\\s*([\"'])(.+?)\\1", 2), new NameOptionMatcher("-I\\s*([^\\s]+)", 1)};

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(true, resultCollector, cwd, argsLine, optionMatchers);
        }
    }

    public static class LangStd_GCC
    extends BuiltinDetectionArgsGeneric
    implements IArglet {
        private static final Matcher[] optionMatchers = new Matcher[]{Pattern.compile("-std=\\S+").matcher(""), Pattern.compile("-ansi").matcher(""), Pattern.compile("-fPIC", 2).matcher(""), Pattern.compile("-fPIE", 2).matcher(""), Pattern.compile("-fstack-protector\\S+").matcher(""), Pattern.compile("-march=\\\\S+").matcher(""), Pattern.compile("-mcpu=\\\\S+").matcher(""), Pattern.compile("-mtune=\\\\S+").matcher(""), Pattern.compile("-pthread").matcher("")};

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(resultCollector, argsLine, optionMatchers);
        }
    }

    public static abstract class MacroDefineGeneric {
        protected final int processArgument(IArglet.IArgumentCollector resultCollector, String args, NameValueOptionMatcher[] optionMatchers) {
            NameValueOptionMatcher[] nameValueOptionMatcherArray = optionMatchers;
            int n = optionMatchers.length;
            int n2 = 0;
            while (n2 < n) {
                NameValueOptionMatcher oMatcher = nameValueOptionMatcherArray[n2];
                Matcher matcher = oMatcher.pattern.matcher(args);
                if (matcher.lookingAt()) {
                    String name = matcher.group(oMatcher.nameGroup);
                    String value = oMatcher.valueGroup == -1 ? null : matcher.group(oMatcher.valueGroup);
                    resultCollector.addDefine(name, value);
                    int end = matcher.end();
                    return end;
                }
                ++n2;
            }
            return 0;
        }
    }

    public static class MacroDefine_C_POSIX
    extends MacroDefineGeneric
    implements IArglet {
        private static final NameValueOptionMatcher[] optionMatchers = new NameValueOptionMatcher[]{new NameValueOptionMatcher("-D\\s*([\\w$]+)(?:\\([\\w$, ]*?\\))?=(([\"'])(?:\\\\\\\\|\\\\\\3|(?!\\3).)*\\3)", 1, 2), new NameValueOptionMatcher("-D\\s*([\\w$]+)(?:\\([\\w$, ]*?\\))?=((\\S+))", 1, 3), new NameValueOptionMatcher("-D\\s*([\"'])([\\w$]+)(?:\\([\\w$, ]*?\\))?=((.+?))\\1", 2, 4), new NameValueOptionMatcher("-D\\s*([\\w$]+)(?:\\([\\w$, ]*?\\))?", 1, -1)};

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(resultCollector, argsLine, optionMatchers);
        }
    }

    public static class MacroUndefineGeneric {
        protected final int processArgument(IArglet.IArgumentCollector resultCollector, String argsLine, NameOptionMatcher optionMatcher) {
            Matcher oMatcher = optionMatcher.pattern.matcher(argsLine);
            if (oMatcher.lookingAt()) {
                String name = oMatcher.group(1);
                resultCollector.addUndefine(name);
                int end = oMatcher.end();
                return end;
            }
            return 0;
        }
    }

    public static class MacroUndefine_C_POSIX
    extends MacroUndefineGeneric
    implements IArglet {
        private static final NameOptionMatcher optionMatcher = new NameOptionMatcher("-U\\s*([\\w$]+)(?:\\([\\w$, ]*?\\))?", 1);

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(resultCollector, argsLine, optionMatcher);
        }
    }

    public static abstract class MacrosFileGeneric {
        protected final int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine, NameOptionMatcher[] optionMatchers) {
            NameOptionMatcher[] nameOptionMatcherArray = optionMatchers;
            int n = optionMatchers.length;
            int n2 = 0;
            while (n2 < n) {
                NameOptionMatcher oMatcher = nameOptionMatcherArray[n2];
                Matcher matcher = oMatcher.pattern.matcher(argsLine);
                if (matcher.lookingAt()) {
                    String name = matcher.group(oMatcher.nameGroup);
                    resultCollector.addMacroFile(name);
                    int end = matcher.end();
                    return end;
                }
                ++n2;
            }
            return 0;
        }
    }

    public static class MacrosFile_GCC
    extends MacrosFileGeneric
    implements IArglet {
        private static final NameOptionMatcher[] optionMatchers = new NameOptionMatcher[]{new NameOptionMatcher("-imacros\\s*([\"'])(.+?)\\1", 2), new NameOptionMatcher("-imacros\\s*([^\\s]+)", 1)};

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(resultCollector, cwd, argsLine, optionMatchers);
        }
    }

    public static class NameOptionMatcher {
        @Deprecated(forRemoval=true)
        final Matcher matcher;
        final Pattern pattern;
        final int nameGroup;

        public NameOptionMatcher(String pattern, int nameGroup) {
            this.pattern = Pattern.compile(pattern);
            this.matcher = this.pattern.matcher(Arglets.EMPTY_STR);
            this.nameGroup = nameGroup;
        }

        public String toString() {
            return "NameOptionMatcher [pattern=" + this.pattern + ", nameGroup=" + this.nameGroup + "]";
        }
    }

    public static class NameValueOptionMatcher
    extends NameOptionMatcher {
        private final int valueGroup;

        public NameValueOptionMatcher(String pattern, int nameGroup, int valueGroup) {
            super(pattern, nameGroup);
            this.valueGroup = valueGroup;
        }

        @Override
        public String toString() {
            return "NameValueOptionMatcher [pattern=" + this.pattern + ", nameGroup=" + this.nameGroup + ", valueGroup=" + this.valueGroup + "]";
        }
    }

    public static class Sysroot_GCC
    extends BuiltinDetectionArgsGeneric
    implements IArglet {
        private static final Matcher[] optionMatchers = new Matcher[]{Pattern.compile("--sysroot=\\s*([\"'])(.+?)\\1").matcher(""), Pattern.compile("--sysroot=\\s*([^\\s]+)").matcher(""), Pattern.compile("-isysroot=\\s*([\"'])(.+?)\\1").matcher(""), Pattern.compile("-isysroot=\\s*([^\\s]+)").matcher(""), Pattern.compile("--no-sysroot-prefix").matcher("")};

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(resultCollector, argsLine, optionMatchers);
        }
    }

    public static class SystemIncludePath_C
    extends IncludePathGeneric
    implements IArglet {
        static final NameOptionMatcher[] optionMatchers = new NameOptionMatcher[]{new NameOptionMatcher("-isystem\\s*([\"'])(.+?)\\1", 2), new NameOptionMatcher("-isystem\\s*([^\\s]+)", 1)};

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(true, resultCollector, cwd, argsLine, optionMatchers);
        }
    }

    public static class Target_Clang
    extends BuiltinDetectionArgsGeneric
    implements IArglet {
        private static final Matcher[] optionMatchers = new Matcher[]{Pattern.compile("--target=\\w+(-\\w+)*").matcher("")};

        @Override
        public int processArgument(IArglet.IArgumentCollector resultCollector, IPath cwd, String argsLine) {
            return this.processArgument(resultCollector, argsLine, optionMatchers);
        }
    }
}

