/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.quickoutline;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.quickoutline.QuickOutlinePopup;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class ShowQuickOutlineActionHandler
extends AbstractHandler {
    @Inject
    private Injector injector;

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor(event);
        if (xtextEditor != null) {
            final IXtextDocument document = xtextEditor.getDocument();
            document.priorityReadOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    QuickOutlinePopup quickOutlinePopup = ShowQuickOutlineActionHandler.this.createPopup(xtextEditor.getEditorSite().getShell());
                    quickOutlinePopup.setEditor(xtextEditor);
                    quickOutlinePopup.setInput(document);
                    if (event.getTrigger() != null) {
                        quickOutlinePopup.setEvent((Event)event.getTrigger());
                    }
                    quickOutlinePopup.open();
                }
            });
        }
        return null;
    }

    protected QuickOutlinePopup createPopup(Shell parent) {
        QuickOutlinePopup result = new QuickOutlinePopup(parent);
        this.injector.injectMembers((Object)result);
        return result;
    }
}

