/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;

public interface ITmfProjectModelElement {
    public String getName();

    public IResource getResource();

    public IPath getPath();

    public URI getLocation();

    public TmfProjectElement getProject();

    public ITmfProjectModelElement getParent();

    public List<ITmfProjectModelElement> getChildren();

    default public ITmfProjectModelElement getChild(String name) {
        for (ITmfProjectModelElement child : this.getChildren()) {
            if (!Objects.equals(child.getName(), name)) continue;
            return child;
        }
        return null;
    }

    public void refresh();

    public Image getIcon();

    default public String getLabelText() {
        return this.getName();
    }

    default public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    default public void dispose() {
        this.getChildren().forEach(element -> element.dispose());
    }
}

