/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tcf.te.launch.ui.tabs.AbstractFormsLaunchConfigurationTab;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractCustomFormToolkitEditorPage;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;

public abstract class AbstractLaunchTabContainerEditorPage
extends AbstractCustomFormToolkitEditorPage {
    private final AbstractLaunchConfigurationTab launchTab = this.createLaunchConfigurationTab();
    boolean isDirty = false;

    public AbstractLaunchTabContainerEditorPage() {
        Assert.isNotNull((Object)this.launchTab);
    }

    protected abstract AbstractLaunchConfigurationTab createLaunchConfigurationTab();

    protected final AbstractLaunchConfigurationTab getLaunchConfigurationTab() {
        return this.launchTab;
    }

    public void dispose() {
        this.launchTab.dispose();
        super.dispose();
    }

    protected String getContextHelpId() {
        return this.launchTab.getHelpContextId();
    }

    protected String getFormTitle() {
        return this.launchTab.getName();
    }

    protected Image getFormImage() {
        return this.launchTab.getImage();
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    protected void doCreateFormContent(Composite parent, CustomFormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        if (this.launchTab instanceof AbstractFormsLaunchConfigurationTab) {
            ((AbstractFormsLaunchConfigurationTab)this.launchTab).createFormContent(this.getManagedForm());
        } else {
            this.launchTab.createControl(parent);
        }
        this.getManagedForm().addPart((IFormPart)new AbstractFormPart(){

            public boolean isDirty() {
                return AbstractLaunchTabContainerEditorPage.this.isDirty;
            }

            public void commit(boolean onSave) {
                super.commit(onSave);
                if (onSave) {
                    AbstractLaunchTabContainerEditorPage.this.extractData();
                }
            }
        });
        Color bg = parent.getBackground();
        Control[] children = parent.getChildren();
        if (bg != null && children != null && children.length > 0) {
            this.fixBackgrounds(children, bg);
        }
    }

    public abstract boolean setupData(Object var1);

    public abstract boolean extractData();

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.setupData(this.getEditorInput());
        }
    }

    protected final void fixBackgrounds(Control[] controls, Color bg) {
        Assert.isNotNull((Object)controls);
        Assert.isNotNull((Object)bg);
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            int style;
            Control c = controlArray[n2];
            if ((c instanceof Composite || c instanceof Label || c instanceof Button) && (!(c instanceof Button) || ((style = ((Button)c).getStyle()) & 0x10) != 0 || (style & 0x20) != 0)) {
                Control[] children;
                if (!bg.equals((Object)c.getBackground())) {
                    c.setBackground(bg);
                }
                if (c instanceof Composite && (children = ((Composite)c).getChildren()) != null && children.length > 0) {
                    this.fixBackgrounds(children, bg);
                }
            }
            ++n2;
        }
    }
}

