/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.format;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.business.internal.dialect.NotYetOpenedDiagramAdapter;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CompositeFilterApplicationBuilder;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.semantic.MappingBasedDiagramContentDuplicationSwitch;
import org.eclipse.sirius.diagram.ui.tools.api.format.semantic.MappingBasedSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.diagram.util.MappingBasedSiriusFormatManagerFactoryHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MappingBasedSiriusFormatManagerFactory {
    protected static final MappingBasedSiriusFormatManagerFactory INSTANCE = new MappingBasedSiriusFormatManagerFactory();
    protected MappingBasedDiagramContentDuplicationSwitch diagramContentDuplicationSwitch;
    protected MappingBasedSiriusFormatDataManager formatDataManager;
    protected Map<Node, Node> sourceToTargetNoteMap;
    protected boolean isAppliedOnSequenceDiagram;

    public static MappingBasedSiriusFormatManagerFactory getInstance() {
        return INSTANCE;
    }

    public DDiagram applyFormatOnDiagram(Session sourceSession, DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, Session targetSession, DDiagram targetDiagram, boolean copyNotes) {
        this.checkApplyFormatOnDiagramCallCorrection(sourceDiagram, correspondenceMap, targetDiagram, sourceSession, targetSession);
        this.applyFormatAccordingToMap(sourceSession, sourceDiagram, correspondenceMap, targetSession, targetDiagram, copyNotes);
        return targetDiagram;
    }

    public DDiagram applyFormatOnNewDiagram(Session sourceSession, DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, Session targetSession, String targetDiagramName, EObject targetDiagramRoot, boolean copyNotes) {
        this.checkApplyFormatOnNewDiagramCallCorrection(sourceDiagram, correspondenceMap, targetDiagramName, sourceSession, targetSession, targetDiagramRoot);
        DSemanticDiagram targetDiagram = this.createRepresentation(sourceDiagram, targetSession, targetDiagramName, targetDiagramRoot);
        if (targetDiagram != null) {
            this.applyFormatAccordingToMap(sourceSession, sourceDiagram, correspondenceMap, targetSession, (DDiagram)targetDiagram, copyNotes);
            return targetDiagram;
        }
        return null;
    }

    private void applyFormatAccordingToMap(Session sourceSession, DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, Session targetSession, DDiagram targetDiagram, boolean copyNotes) {
        this.diagramContentDuplicationSwitch = new MappingBasedDiagramContentDuplicationSwitch((DSemanticDiagram)targetDiagram, correspondenceMap, targetSession);
        this.diagramContentDuplicationSwitch.doSwitch((EObject)sourceDiagram);
        this.applyFiltersAndLayersState(sourceDiagram, targetDiagram);
        this.synchronizeTargetDiagram(targetSession, (DSemanticDiagram)targetDiagram);
        DiagramEditPart sourceDiagramEditPart = null;
        DiagramEditPart targetDiagramEditPart = null;
        Collection<DiagramEditPart> sourceDiagramEditParts = null;
        Collection<DiagramEditPart> targetDiagramEditParts = null;
        try {
            sourceDiagramEditParts = this.getDiagramEditPart(sourceSession, (DRepresentation)sourceDiagram);
            targetDiagramEditParts = this.getDiagramEditPart(targetSession, (DRepresentation)targetDiagram);
            if (!sourceDiagramEditParts.isEmpty() && !targetDiagramEditParts.isEmpty()) {
                sourceDiagramEditPart = sourceDiagramEditParts.stream().findFirst().get();
                targetDiagramEditPart = targetDiagramEditParts.stream().findFirst().get();
                this.applyFormatOnDiagram(sourceDiagramEditPart, correspondenceMap, targetDiagramEditPart);
                this.synchronizeTargetDiagram(targetSession, (DSemanticDiagram)targetDiagram);
                if (copyNotes) {
                    this.copyNotes(sourceDiagram, targetDiagram, targetSession);
                    this.synchronizeTargetDiagram(targetSession, (DSemanticDiagram)targetDiagram);
                }
                MappingBasedSiriusFormatManagerFactoryHelper.applyNodeDepthPositions(sourceDiagram, targetDiagram, copyNotes, this.diagramContentDuplicationSwitch, this.sourceToTargetNoteMap);
                this.synchronizeTargetDiagram(targetSession, (DSemanticDiagram)targetDiagram);
            }
        }
        catch (Throwable throwable) {
            EclipseUIUtil.synchronizeWithUIThread();
            if (sourceDiagramEditParts != null) {
                sourceDiagramEditParts.stream().forEach(dep -> this.cleanAndDispose((DiagramEditPart)dep));
            }
            if (targetDiagramEditParts != null) {
                targetDiagramEditParts.stream().forEach(dep -> this.cleanAndDispose((DiagramEditPart)dep));
            }
            throw throwable;
        }
        EclipseUIUtil.synchronizeWithUIThread();
        if (sourceDiagramEditParts != null) {
            sourceDiagramEditParts.stream().forEach(dep -> this.cleanAndDispose((DiagramEditPart)dep));
        }
        if (targetDiagramEditParts != null) {
            targetDiagramEditParts.stream().forEach(dep -> this.cleanAndDispose((DiagramEditPart)dep));
        }
    }

    private void applyFiltersAndLayersState(DDiagram sourceDiagram, DDiagram targetDiagram) {
        DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility(targetDiagram);
        Optional<ResourceSet> optionalTargetResourceSet = Optional.ofNullable(targetDiagram).map(EObject::eResource).map(Resource::getResourceSet);
        if (optionalTargetResourceSet.isPresent()) {
            ResourceSet targetResourceSet = optionalTargetResourceSet.get();
            sourceDiagram.getActivatedLayers().forEach(layer -> {
                EObject targetLayer = targetResourceSet.getEObject(EcoreUtil.getURI((EObject)layer), false);
                if (targetLayer instanceof Layer) {
                    targetDiagram.getActivatedLayers().add((Object)((Layer)targetLayer));
                }
            });
            targetDiagram.getActivatedFilters().clear();
            sourceDiagram.getActivatedFilters().forEach(filter -> {
                EObject targetFilter = targetResourceSet.getEObject(EcoreUtil.getURI((EObject)filter), false);
                if (targetFilter instanceof FilterDescription) {
                    targetDiagram.getActivatedFilters().add((Object)((FilterDescription)targetFilter));
                }
            });
            if (targetDiagram.getActivatedFilters().size() != 0) {
                CompositeFilterApplicationBuilder builder = new CompositeFilterApplicationBuilder(targetDiagram);
                builder.computeCompositeFilterApplications();
            }
            if (DisplayMode.NORMAL.equals((Object)DisplayServiceManager.INSTANCE.getMode())) {
                DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility(targetDiagram);
            }
        }
    }

    private void checkApplyFormatOnDiagramCallCorrection(DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, DDiagram targetDiagram, Session sourceSession, Session targetSession) {
        this.checkDiagram(sourceDiagram);
        this.checkDiagram(targetDiagram);
        this.checkSourceDiagramVSTargetDiagram(sourceDiagram, targetDiagram);
        this.checkSourceAndTargetSessions(sourceSession, targetSession);
        this.isAppliedOnSequenceDiagram = this.computeIsSequenceDiagram(sourceDiagram);
        this.checkMapSourceCorrection(sourceDiagram, correspondenceMap);
    }

    private void checkDiagram(DDiagram diagram) {
        if (diagram == null) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorDiagramIsNull);
        }
    }

    private void checkSourceDiagramVSTargetDiagram(DDiagram sourceDiagram, DDiagram targetDiagram) {
        if (sourceDiagram.equals(targetDiagram)) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorSourceAndTargetDiagramsAreTheSame);
        }
        if (!EqualityHelper.areEquals((EObject)sourceDiagram.getDescription(), (EObject)targetDiagram.getDescription())) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ErrorSourceAndTargetDiagramDecriptionsDoesNotMatch, sourceDiagram.getDescription().getName(), targetDiagram.getDescription().getName(), sourceDiagram.getDescription(), targetDiagram.getDescription()));
        }
    }

    private void checkSourceAndTargetSessions(Session sourceSession, Session targetSession) {
        if (sourceSession == null || targetSession == null) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorSourceAndOrTargetSessionsNull);
        }
    }

    private void checkApplyFormatOnNewDiagramCallCorrection(DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, String targetDiagramName, Session sourceSession, Session targetSession, EObject targetDiagramRoot) {
        this.checkDiagram(sourceDiagram);
        if (targetDiagramName == null || targetDiagramName.isEmpty()) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorTargetDiagramNameIsEmpty);
        }
        if (targetDiagramRoot == null) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorTargetDiagramRootIsNull);
        }
        this.checkSourceAndTargetSessions(sourceSession, targetSession);
        this.isAppliedOnSequenceDiagram = this.computeIsSequenceDiagram(sourceDiagram);
        this.checkMapSourceCorrection(sourceDiagram, correspondenceMap);
    }

    private void checkMapSourceCorrection(DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap) {
        if (correspondenceMap.isEmpty()) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorMappingfunctionIsEmpty);
        }
        if (this.isAppliedOnSequenceDiagram) {
            List allSourceDiagramSemanticElements = sourceDiagram.getDiagramElements().stream().map(DSemanticDecorator::getTarget).collect(Collectors.toList());
            boolean contains = correspondenceMap.keySet().containsAll(allSourceDiagramSemanticElements);
            if (!contains) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ErrorMappingfunctionIncompleteOnSequenceDiagram, sourceDiagram));
            }
        }
    }

    private void synchronizeTargetDiagram(Session targetSession, DSemanticDiagram targetDiagram) {
        Diagram targetGMFDiagram;
        DialectManager.INSTANCE.refresh((DRepresentation)targetDiagram, (IProgressMonitor)new NullProgressMonitor());
        DiagramCreationUtil targetDiagramUtil = new DiagramCreationUtil((DDiagram)targetDiagram);
        if (!targetDiagramUtil.findAssociatedGMFDiagram()) {
            targetDiagramUtil.createNewGMFDiagram();
        }
        if ((targetGMFDiagram = targetDiagramUtil.getAssociatedGMFDiagram()) != null) {
            Set<View> set2;
            CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(targetGMFDiagram);
            canonicalSynchronizer.storeViewsToArrange(false);
            canonicalSynchronizer.synchronize();
            Map<Diagram, Set<View>> viewToArrangeCenter = SiriusLayoutDataManager.INSTANCE.getCreatedViewWithCenterLayout();
            Map<Diagram, Set<View>> viewToArrange = SiriusLayoutDataManager.INSTANCE.getCreatedViewsToLayout();
            Set<View> set = viewToArrange.get(targetGMFDiagram);
            if (set != null) {
                set.clear();
            }
            if ((set2 = viewToArrangeCenter.get(targetGMFDiagram)) != null) {
                set2.clear();
            }
        }
    }

    private DSemanticDiagram createRepresentation(DDiagram sourceDiagram, Session targetSession, String targetDiagramName, EObject targetDiagramRoot) {
        Collection selectedViewpoints = targetSession.getSelectedViewpoints(true);
        Collection descs = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints, targetDiagramRoot);
        DRepresentation targetRepresentation = null;
        String sourceDescName = sourceDiagram.getDescription().getName();
        Optional<RepresentationDescription> optDesc = descs.stream().filter(desc -> desc.getName().equals(sourceDescName)).findFirst();
        if (optDesc.isPresent()) {
            targetRepresentation = DialectManager.INSTANCE.createRepresentation(targetDiagramName, targetDiagramRoot, optDesc.get(), targetSession, (IProgressMonitor)new NullProgressMonitor());
            DSemanticDiagram targetDiagram = (DSemanticDiagram)targetRepresentation;
            if (targetDiagram.eAdapters().contains((Object)NotYetOpenedDiagramAdapter.INSTANCE)) {
                targetDiagram.eAdapters().remove((Object)NotYetOpenedDiagramAdapter.INSTANCE);
            }
            return targetDiagram;
        }
        DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ImpossibleToSuitableDescription, descs.stream().map(desc -> desc.getName()).collect(Collectors.joining(", ")), sourceDescName, SiriusEditPlugin.getPlugin().getUiCallback().getSessionNameToDisplayWhileSaving(targetSession)));
        return null;
    }

    private void applyFormatOnDiagram(DiagramEditPart sourceDiagramEditPart, Map<EObject, EObject> correspondenceMap, DiagramEditPart targetDiagramEditPart) {
        this.formatDataManager = new MappingBasedSiriusFormatDataManager(correspondenceMap);
        this.formatDataManager.storeFormatData((IGraphicalEditPart)sourceDiagramEditPart);
        if (this.isAppliedOnSequenceDiagram) {
            for (Map.Entry<DDiagramElement, DDiagramElement> entry : this.diagramContentDuplicationSwitch.getSourceDDiagramElementToTargetDDiagramElementMap().entrySet()) {
                View sourceGmfView = SiriusGMFHelper.getGmfView(entry.getKey());
                View targetGmfView = SiriusGMFHelper.getGmfView(entry.getValue());
                if (sourceGmfView instanceof Node && targetGmfView instanceof Node) {
                    Node sourceNode = (Node)sourceGmfView;
                    Node targetNode = (Node)targetGmfView;
                    MappingBasedSiriusFormatManagerFactoryHelper.copyNodeLayout(sourceNode, targetNode);
                    this.formatDataManager.copySiriusStyle((DSemanticDecorator)entry.getKey(), (DSemanticDecorator)entry.getValue());
                    this.formatDataManager.copyGMFStyle((View)sourceNode, (View)targetNode);
                    if (!(entry.getKey() instanceof DNode) || !new DNodeQuery((DNode)entry.getKey()).hasLabelOnBorder()) continue;
                    MappingBasedSiriusFormatManagerFactoryHelper.copyBorderLabelLayout(sourceNode, targetNode);
                    continue;
                }
                if (!(sourceGmfView instanceof Edge) || !(targetGmfView instanceof Edge)) continue;
                Edge sourceEdge = (Edge)sourceGmfView;
                Edge targetEdge = (Edge)targetGmfView;
                MappingBasedSiriusFormatManagerFactoryHelper.copyEdgeLayout(sourceEdge, targetEdge);
                this.formatDataManager.copySiriusStyle((DSemanticDecorator)entry.getKey(), (DSemanticDecorator)entry.getValue());
                this.formatDataManager.copyGMFStyle((View)sourceEdge, (View)targetEdge);
            }
        } else {
            this.formatDataManager.applyFormat((IGraphicalEditPart)targetDiagramEditPart);
        }
    }

    private boolean computeIsSequenceDiagram(DDiagram sourceDiagram) {
        boolean isSequenceDiagram = false;
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(sourceDiagram.getDescription().eClass().getEPackage())) continue;
            isSequenceDiagram = diagramTypeDescriptor.getDiagramDescriptionProvider().requiresNonStandardFormatDataManagers();
            break;
        }
        return isSequenceDiagram;
    }

    private Collection<DiagramEditPart> getDiagramEditPart(Session session, DRepresentation representation) {
        ArrayList<DiagramEditPart> result = new ArrayList<DiagramEditPart>();
        Collection data = session.getServices().getCustomData("GMF_DIAGRAMS", (EObject)representation);
        for (EObject dataElement : data) {
            if (!(dataElement instanceof Diagram)) continue;
            Shell shell = new Shell();
            Diagram diagram = (Diagram)dataElement;
            DiagramEditPartService tool = new DiagramEditPartService();
            DiagramEditPart diagramEditPart = tool.createDiagramEditPart(diagram, shell, PreferencesHint.USE_DEFAULTS);
            result.add(diagramEditPart);
        }
        return result;
    }

    private void copyNotes(DDiagram sourceDiagram, DDiagram targetDiagram, Session targetSession) {
        Diagram sourceGMFDiagram = MappingBasedSiriusFormatManagerFactoryHelper.getGMFDiagram(sourceDiagram);
        Diagram targetGMFDiagram = MappingBasedSiriusFormatManagerFactoryHelper.getGMFDiagram(targetDiagram);
        if (this.sourceToTargetNoteMap == null) {
            this.sourceToTargetNoteMap = new HashMap<Node, Node>();
        }
        this.sourceToTargetNoteMap.clear();
        Collection<Node> sourceNotes = GMFNotationHelper.getNotes(sourceGMFDiagram);
        Collection<Node> targetNotes = GMFNotationHelper.getNotes(targetGMFDiagram);
        sourceNotes.forEach(sourceNote -> {
            if (sourceNote instanceof Shape && ((Shape)sourceNote).getDescription() != null) {
                String labelOfNote = ((Shape)sourceNote).getDescription();
                Optional<Node> existingTargetNote = this.search(targetNotes, (Shape)sourceNote, labelOfNote);
                Node targetNote = existingTargetNote.isPresent() ? existingTargetNote.get() : GMFNotationHelper.createNote(targetGMFDiagram, GMFNotationHelper.getNoteDescription(sourceNote));
                targetNote.setLayoutConstraint((LayoutConstraint)EcoreUtil.copy((EObject)sourceNote.getLayoutConstraint()));
                if (sourceNote.isSetElement()) {
                    targetNote.setElement(sourceNote.getElement());
                }
                this.formatDataManager.copyGMFStyle((View)sourceNote, (View)targetNote);
                this.sourceToTargetNoteMap.put((Node)sourceNote, targetNote);
            }
        });
        Collection<Node> sourceTexts = GMFNotationHelper.getTextNotes(sourceGMFDiagram);
        Collection<Node> targetTexts = GMFNotationHelper.getTextNotes(targetGMFDiagram);
        sourceTexts.forEach(sourceText -> {
            Object targetParentNode = null;
            targetParentNode = sourceText.eContainer().equals(sourceGMFDiagram) ? targetGMFDiagram : MappingBasedSiriusFormatManagerFactoryHelper.getTargetDiagramTextNoteContainer(sourceText, this.diagramContentDuplicationSwitch);
            if (targetParentNode == null) {
                DiagramPlugin.getDefault().logInfo(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ImpossibleToFindTargetTextNoteContainer, sourceText));
                return;
            }
            if (sourceText instanceof Shape && ((Shape)sourceText).getDescription() != null) {
                String labelOfText = ((Shape)sourceText).getDescription();
                Optional<Node> existingTargetText = this.search(targetTexts, (Shape)sourceText, labelOfText);
                Node targetText = existingTargetText.isPresent() ? existingTargetText.get() : GMFNotationHelper.createTextNote((View)targetParentNode, labelOfText);
                targetText.setLayoutConstraint((LayoutConstraint)EcoreUtil.copy((EObject)sourceText.getLayoutConstraint()));
                if (sourceText.isSetElement()) {
                    targetText.setElement(sourceText.getElement());
                }
                this.formatDataManager.copyGMFStyle((View)sourceText, (View)targetText);
                this.sourceToTargetNoteMap.put((Node)sourceText, targetText);
            }
        });
        Collection<Edge> notesAttachments = GMFNotationHelper.getNotesAttachments(sourceGMFDiagram);
        notesAttachments.forEach(attach -> {
            View nodeAttachment = attach.getSource();
            Boolean noteIsSource = true;
            if (!this.isNoteOrText(nodeAttachment)) {
                nodeAttachment = attach.getTarget();
                noteIsSource = false;
            }
            MappingBasedSiriusFormatManagerFactoryHelper.duplicateNoteAttachment(attach, this.sourceToTargetNoteMap.get(nodeAttachment), targetSession, noteIsSource, this.diagramContentDuplicationSwitch, this.sourceToTargetNoteMap, this.formatDataManager, targetGMFDiagram);
        });
    }

    private boolean isNoteOrText(View nodeAttachment) {
        return nodeAttachment instanceof Node && (GMFNotationHelper.isNote((Node)nodeAttachment) || GMFNotationHelper.isTextNote((Node)nodeAttachment));
    }

    private Optional<Node> search(Collection<Node> nodes, Shape sourceNode, String searchedLabel) {
        List<Node> matchingNodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!(node instanceof Shape) || !searchedLabel.equals(((Shape)node).getDescription())) continue;
            matchingNodes.add(node);
        }
        matchingNodes = this.removeNotSameAttachment(sourceNode, matchingNodes, true);
        matchingNodes = this.removeNotSameAttachment(sourceNode, matchingNodes, false);
        return matchingNodes.stream().findFirst();
    }

    protected List<Node> removeNotSameAttachment(Shape nodeToCompareWith, List<Node> nodesCandidates, boolean testSource) {
        List<Object> matchingNodes;
        boolean hasAttachment;
        boolean bl = testSource ? nodeToCompareWith.getSourceEdges().size() != 0 : (hasAttachment = nodeToCompareWith.getTargetEdges().size() != 0);
        if (!hasAttachment) {
            matchingNodes = testSource ? nodesCandidates.stream().filter(node -> node.getSourceEdges().size() == 0).collect(Collectors.toList()) : nodesCandidates.stream().filter(node -> node.getTargetEdges().size() == 0).collect(Collectors.toList());
        } else {
            matchingNodes = new ArrayList<Node>(nodesCandidates);
            Iterator iterator = matchingNodes.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                boolean sameAttachments = true;
                Iterator edgesIterators = testSource ? nodeToCompareWith.getSourceEdges().iterator() : nodeToCompareWith.getTargetEdges().iterator();
                while (edgesIterators.hasNext()) {
                    Edge e = (Edge)edgesIterators.next();
                    EObject otherExtremityElement = testSource ? e.getTarget().getElement() : e.getSource().getElement();
                    DDiagramElement targetDiagramElement = this.diagramContentDuplicationSwitch.getSourceDDiagramElementToTargetDDiagramElementMap().get(otherExtremityElement);
                    if (targetDiagramElement != null && targetDiagramElement.eResource() != null) {
                        if (testSource) {
                            sameAttachments = sameAttachments && node2.getSourceEdges().stream().anyMatch(edge -> ((Edge)edge).getTarget().getElement().equals(targetDiagramElement));
                            continue;
                        }
                        sameAttachments = sameAttachments && node2.getTargetEdges().stream().anyMatch(edge -> ((Edge)edge).getSource().getElement().equals(targetDiagramElement));
                        continue;
                    }
                    DiagramPlugin.getDefault().logInfo(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ImpossibleToCopyNoteInNonExistingOrUnreachableTarget, e.getTarget()));
                }
                if (sameAttachments) continue;
                iterator.remove();
            }
        }
        return matchingNodes;
    }

    private void cleanAndDispose(DiagramEditPart diagramEditPart) {
        if (diagramEditPart != null) {
            diagramEditPart.deactivate();
            diagramEditPart.getViewer().flush();
            diagramEditPart.getViewer().getEditDomain().getCommandStack().flush();
            Control control = diagramEditPart.getViewer().getControl();
            if (control.getParent() != null) {
                control.getParent().dispose();
            } else {
                control.isDisposed();
            }
            ((DiagramEditDomain)diagramEditPart.getViewer().getEditDomain()).removeViewer(diagramEditPart.getViewer());
        }
    }
}

