/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.mylyn.tasks.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.mylyn.tasks.ui.views.TaskList;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.TreeItemHasMinChildren;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class TaskListView
extends WorkbenchView {
    public static final String TITLE = "Task List";

    public TaskListView() {
        super(TITLE);
    }

    public List<TaskList> getTaskLists() {
        DefaultTree tree;
        ArrayList<TaskList> theTaskLists = new ArrayList<TaskList>();
        this.activate();
        try {
            tree = new DefaultTree();
        }
        catch (SWTLayerException sWTLayerException) {
            return new ArrayList<TaskList>();
        }
        for (TreeItem item : tree.getItems()) {
            theTaskLists.add(new TaskList(item));
        }
        return theTaskLists;
    }

    public TaskList getTaskList(String name) {
        this.activate();
        for (TaskList repository : this.getTaskLists()) {
            if (!repository.getName().equals(name)) continue;
            return repository;
        }
        throw new EclipseLayerException("There is no repository with name " + name);
    }

    protected Tree getRepositoriesTree() {
        this.activate();
        return new DefaultTree();
    }

    public TreeItem getTask(String taskCategory, String taskName) {
        this.activate();
        new DefaultTree();
        DefaultTreeItem theCategory = new DefaultTreeItem(new String[]{taskCategory});
        new WaitUntil((WaitCondition)new TreeItemHasMinChildren((TreeItem)theCategory, 1), TimePeriod.getCustom((long)60L));
        DefaultTreeItem theTask = new DefaultTreeItem(new String[]{taskCategory, taskName});
        theTask.select();
        return theTask;
    }

    public void createLocalTaskTest() {
        this.activate();
        new ShellMenuItem(new String[]{"File", "New", "Other..."}).select();
        new DefaultTree();
        DefaultTreeItem theNewTask = new DefaultTreeItem(new String[]{"Tasks", "Task"});
        theNewTask.select();
        new PushButton("Next >").click();
        new DefaultTree();
        DefaultTreeItem theLocalRepo = new DefaultTreeItem(new String[]{"Local"});
        theLocalRepo.select();
        new PushButton("Finish").click();
    }
}

