/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.lang.reflect.Field;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ItemHandler;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class CTabItemHandler
extends ItemHandler {
    private static final Logger logger = Logger.getLogger(CTabItemHandler.class);
    private static CTabItemHandler instance;

    public static CTabItemHandler getInstance() {
        if (instance == null) {
            instance = new CTabItemHandler();
        }
        return instance;
    }

    public CTabFolder getCTabFolder(final CTabItem swtCTabItem) {
        return (CTabFolder)Display.syncExec((ResultRunnable)new ResultRunnable<CTabFolder>(){

            public CTabFolder run() {
                return swtCTabItem.getParent();
            }
        });
    }

    public Control getControl(final CTabItem ctabItem) {
        return (Control)Display.syncExec((ResultRunnable)new ResultRunnable<Control>(){

            public Control run() {
                return ctabItem.getControl();
            }
        });
    }

    public Event createEventForCTabItem(CTabItem swtCTabItem, int type) {
        Event event = new Event();
        event.type = type;
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.item = swtCTabItem;
        event.widget = this.getCTabFolder(swtCTabItem);
        return event;
    }

    public void notifyCTabFolder(final CTabItem swtCTabItem, final Event event) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtCTabItem.getParent().notifyListeners(event.type, event);
            }
        });
    }

    public void clickCloseButton(final CTabItem swtCTabItem) {
        Rectangle rectangleCloseBox = (Rectangle)Display.syncExec((ResultRunnable)new ResultRunnable<Rectangle>(){

            public Rectangle run() {
                try {
                    Field field = CTabItem.class.getDeclaredField("closeRect");
                    field.setAccessible(true);
                    return (Rectangle)field.get(swtCTabItem);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        logger.debug("Click on close button");
        int x = rectangleCloseBox.x + rectangleCloseBox.width / 2;
        int y = rectangleCloseBox.y + rectangleCloseBox.height / 2;
        this.notifyCTabFolder(swtCTabItem, this.createMouseEvent(swtCTabItem, 3, x, y, 1, 0, 1));
        this.notifyCTabFolder(swtCTabItem, this.createMouseEvent(swtCTabItem, 4, x, y, 1, 524288, 1));
    }

    private Event createMouseEvent(CTabItem swtCTabItem, int type, int x, int y, int button, int stateMask, int count) {
        Event event = this.createEventForCTabItem(swtCTabItem, type);
        event.time = (int)System.currentTimeMillis();
        event.x = x;
        event.y = y;
        event.button = button;
        event.stateMask = stateMask;
        event.count = count;
        return event;
    }

    public boolean isShowClose(final CTabItem swtCTabItem) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return swtCTabItem.getShowClose();
            }
        });
    }

    public boolean isShowing(final CTabItem swtCTabItem) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return swtCTabItem.isShowing();
            }
        });
    }

    public void select(final CTabItem cTabItem) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                cTabItem.getParent().setSelection(cTabItem);
            }
        });
    }

    public void activate(CTabItem item) {
        this.select(item);
        this.notifyCTabFolder(item, this.createEventForCTabItem(item, 13));
    }

    public void setFocus(CTabItem ctabItem) {
        ControlHandler.getInstance().setFocus((Control)this.getParent(ctabItem));
    }

    public CTabFolder getParent(final CTabItem ctabItem) {
        return (CTabFolder)Display.syncExec((ResultRunnable)new ResultRunnable<CTabFolder>(){

            public CTabFolder run() {
                return ctabItem.getParent();
            }
        });
    }

    public String getToolTipText(final CTabItem tabItem) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return tabItem.getToolTipText();
            }
        });
    }
}

