/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.entities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.php.composer.api.ComposerConstants;
import org.eclipse.php.composer.api.entities.Entity;

public class Version
extends Entity
implements Comparable<Version> {
    public static final int BEGIN = 0;
    public static final int END = 1;
    private List<Version> versions = new ArrayList<Version>();
    private String version;
    private String constraint = "";
    private String stabilityModifier = "";
    private String major = "";
    private String minor = "";
    private String fix = "";
    private String build = "";
    private String stability = "";
    private String suffix = "";
    private String prefix = "";
    private int devPosition = 1;

    public Version() {
    }

    public Version(String version) {
        this.parse(version);
    }

    private void parse(String version) {
        this.clear();
        if (version.matches(",")) {
            String[] parts = version.split(",");
            this.versions.add(this);
            this.parseVersion(parts[0]);
            int i = 1;
            while (i < parts.length) {
                Version v = new Version(parts[i]);
                v.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        Version.this.reset();
                    }
                });
                this.versions.add(v);
                ++i;
            }
            this.version = null;
        } else {
            this.parseVersion(version);
        }
    }

    private void parseVersion(String version) {
        int len;
        String[] parts;
        this.version = version;
        String constraintPattern = "^(<>|!=|>=?|<=?|==?)?(.+)";
        if (version.matches(constraintPattern)) {
            this.constraint = version.replaceAll(constraintPattern, "$1");
            version = version.replaceAll(constraintPattern, "$2");
        }
        if (version.matches(".+@.+")) {
            parts = version.split("@");
            version = parts[0];
            this.stabilityModifier = this.normalizeStability(parts[1]);
        }
        if (version.startsWith("dev-")) {
            this.stability = "dev";
            version = version.substring(4);
            this.devPosition = 0;
        }
        if ((len = (parts = version.split("-")).length) > 0) {
            this.parseMain(parts[0]);
        }
        if (len > 1) {
            this.parseTail(parts[1]);
        }
        if (this.stability.isEmpty()) {
            this.stability = "stable";
        }
    }

    private void parseMain(String main) {
        if (main.contains(".")) {
            String[] parts = main.split("\\.");
            int len = parts.length;
            if (len > 0) {
                Pattern pattern = Pattern.compile("(\\D+)?(\\d+)", 2);
                Matcher matcher = pattern.matcher(parts[0]);
                matcher.find();
                if (matcher.group(1) != null) {
                    this.prefix = matcher.group(1);
                }
                if (matcher.group(2) != null) {
                    this.major = matcher.group(2);
                }
            }
            if (len > 1) {
                this.minor = parts[1];
            }
            if (len > 2) {
                this.fix = parts[2];
            }
            if (len > 3) {
                this.build = parts[3];
            }
        } else {
            this.major = main;
        }
    }

    private void parseTail(String tail) {
        Pattern pattern = Pattern.compile("[._-]?(?:(stable|beta|b|RC|alpha|a|patch|pl|p)(?:[.-]?(\\d+))?)?([.-]?dev)?", 2);
        Matcher matcher = pattern.matcher(tail);
        matcher.find();
        if (matcher.group(2) != null && !matcher.group(2).isEmpty()) {
            this.suffix = matcher.group(2);
        }
        if (this.stability.isEmpty()) {
            if (matcher.group(3) != null && !matcher.group(3).isEmpty()) {
                this.stability = "dev";
            } else if (matcher.group(1) != null && !matcher.group(1).isEmpty()) {
                this.stability = this.normalizeStability(matcher.group(1));
            }
        }
    }

    private String normalizeStability(String stabi) {
        if (stabi.equalsIgnoreCase("dev")) {
            return "dev";
        }
        if (stabi.equalsIgnoreCase("beta") || stabi.equalsIgnoreCase("b")) {
            return "beta";
        }
        if (stabi.equalsIgnoreCase("alpha") || stabi.equalsIgnoreCase("a")) {
            return "alpha";
        }
        if (stabi.equalsIgnoreCase("rc")) {
            return "RC";
        }
        if (stabi.equalsIgnoreCase("stable")) {
            return "stable";
        }
        return "";
    }

    private String build() {
        StringBuilder sb = new StringBuilder();
        if (!this.constraint.isEmpty()) {
            sb.append(this.constraint);
        }
        if (this.devPosition == 0 && this.stability == "dev") {
            sb.append("dev-");
        }
        if (!this.prefix.isEmpty()) {
            sb.append(this.prefix);
        }
        sb.append(this.major);
        if (!this.minor.isEmpty()) {
            sb.append(".");
            sb.append(this.minor);
        }
        if (!this.fix.isEmpty()) {
            sb.append(".");
            sb.append(this.fix);
        }
        if (!this.build.isEmpty()) {
            sb.append(".");
            sb.append(this.build);
        }
        StringBuilder sx = new StringBuilder();
        if (!(this.stability.isEmpty() || this.stability == "stable" || this.stability == "dev" && this.devPosition == 0)) {
            sx.append(this.stability);
        }
        if (!this.suffix.isEmpty()) {
            sx.append(this.suffix);
        }
        if (sx.length() > 0) {
            sb.append("-");
            sb.append((CharSequence)sx);
        }
        if (!this.stabilityModifier.isEmpty()) {
            sb.append("@");
            sb.append(this.stabilityModifier);
        }
        if (this.versions.size() > 0) {
            int i = 1;
            for (Version v : this.versions) {
                sb.append(v.toString());
                if (i < this.versions.size()) {
                    sb.append(",");
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public boolean hasRange() {
        return this.versions.size() > 0;
    }

    public Version getLowest() {
        return this;
    }

    public Version getHighest() {
        if (this.versions == null) {
            return null;
        }
        return this.versions.get(this.versions.size() - 1);
    }

    public void clear() {
        this.versions.clear();
        this.constraint = "";
        this.stabilityModifier = "";
        this.major = "";
        this.minor = "";
        this.fix = "";
        this.build = "";
        this.stability = "";
        this.suffix = "";
        this.prefix = "";
        this.devPosition = 1;
        this.version = null;
    }

    public Version getVersion(int index) {
        if (this.versions.size() > index) {
            return this.versions.get(index);
        }
        return null;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public void add(Version version) {
        this.versions.add(this.versions.size(), version);
    }

    public void add(int index, Version version) {
        this.versions.add(index, version);
        this.reset();
    }

    private void reset() {
        this.version = "";
    }

    public String toString() {
        if ("".equals(this.version) || this.version == null) {
            this.version = this.build();
        }
        return this.version;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getStabilityModifier() {
        return this.stabilityModifier;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getFix() {
        return this.fix;
    }

    public String getBuild() {
        return this.build;
    }

    public String getStability() {
        return this.stability;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setVersion(String version) {
        String oldVersion = this.version;
        this.versions.clear();
        this.parse(version);
        this.firePropertyChange("version", oldVersion, this.version);
    }

    public void from(Version version) {
        String oldVersion = this.version;
        this.reset();
        this.versions.clear();
        this.versions.addAll(version.getVersions());
        this.constraint = version.getConstraint();
        this.stabilityModifier = version.getStabilityModifier();
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.fix = version.getFix();
        this.build = version.getBuild();
        this.stability = version.getStability();
        this.suffix = version.getSuffix();
        this.prefix = version.getPrefix();
        this.devPosition = version.getDevPosition();
        this.firePropertyChange("version", oldVersion, this.toString());
    }

    public void setConstraint(String constraint) {
        this.reset();
        this.constraint = constraint;
        this.firePropertyChange("constraint", this.constraint, this.constraint);
    }

    public void setStabilityModifier(String stabilityModifier) {
        this.reset();
        this.stabilityModifier = stabilityModifier;
        this.firePropertyChange("stabilityModifier", this.stabilityModifier, this.stabilityModifier);
    }

    public void setMajor(String major) {
        this.reset();
        this.major = major;
        this.firePropertyChange("major", this.major, this.major);
    }

    public void setMinor(String minor) {
        this.reset();
        this.minor = minor;
        this.firePropertyChange("minor", this.minor, this.minor);
    }

    public void setFix(String fix) {
        this.reset();
        this.fix = fix;
        this.firePropertyChange("fix", this.fix, this.fix);
    }

    public void setBuild(String build) {
        this.reset();
        this.build = build;
        this.firePropertyChange("build", this.build, this.build);
    }

    public void setStability(String stability) {
        this.reset();
        this.stability = stability;
        this.firePropertyChange("stability", this.stability, this.stability);
    }

    public void setSuffix(String suffix) {
        this.reset();
        this.suffix = suffix;
        this.firePropertyChange("suffix", this.suffix, this.suffix);
    }

    public int getDevPosition() {
        return this.devPosition;
    }

    public void setDevPosition(int devPosition) {
        this.reset();
        this.devPosition = devPosition;
        this.firePropertyChange("devPosition", this.devPosition, this.devPosition);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.reset();
        this.prefix = prefix;
        this.firePropertyChange("prefix", this.prefix, this.prefix);
    }

    @Override
    public int compareTo(Version anotherVersion) {
        if ("dev-master".equals(this.toString())) {
            return -1;
        }
        if ("dev-master".equals(anotherVersion.toString())) {
            return 1;
        }
        int major = this.cmp(this.getMajor(), anotherVersion.getMajor());
        if (major == 0) {
            int minor = this.cmp(this.getMinor(), anotherVersion.getMinor());
            if (minor == 0) {
                int fix = this.cmp(this.getFix(), anotherVersion.getFix());
                if (fix == 0) {
                    int build = this.cmp(this.getBuild(), anotherVersion.getBuild());
                    if (build == 0) {
                        int s2;
                        int s1 = Arrays.binarySearch(ComposerConstants.STABILITIES, this.getStability());
                        if (s1 == (s2 = Arrays.binarySearch(ComposerConstants.STABILITIES, anotherVersion.getStability()))) {
                            return this.cmp(this.getSuffix(), anotherVersion.getSuffix());
                        }
                        return s1 > s2 ? -1 : 1;
                    }
                    return build;
                }
                return fix;
            }
            return minor;
        }
        return major;
    }

    private int cmp(String s1, String s2) {
        int i1 = 0;
        int i2 = 0;
        boolean l1 = true;
        boolean l2 = true;
        try {
            i1 = Integer.parseInt(s1, 10);
            l1 = false;
        }
        catch (Exception exception) {}
        try {
            i2 = Integer.parseInt(s2, 10);
            l2 = false;
        }
        catch (Exception exception) {}
        if (l1 && l2) {
            return s1.compareTo(s2);
        }
        if (l1 && !l2) {
            return 1;
        }
        if (!l1 && l2) {
            return -1;
        }
        if (i1 == i2) {
            return 0;
        }
        return i1 > i2 ? 1 : -1;
    }
}

