/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl.delta;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaWithProperties;
import org.eclipse.net4j.db.ddl.delta.IDBPropertyDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBPropertyDelta;

public abstract class DBDeltaWithProperties
extends DBDelta
implements IDBDeltaWithProperties {
    private static final long serialVersionUID = 1L;
    private Map<String, IDBPropertyDelta<?>> propertyDeltas = new HashMap();

    public DBDeltaWithProperties(DBDelta parent, String name, IDBDelta.ChangeKind changeKind) {
        super(parent, name, changeKind);
    }

    protected DBDeltaWithProperties() {
    }

    public <T> DBPropertyDelta<T> getPropertyDelta(String name) {
        name = DBDeltaWithProperties.name(name);
        DBPropertyDelta propertyDelta = (DBPropertyDelta)this.propertyDeltas.get(name);
        return propertyDelta;
    }

    @Override
    public <T> T getPropertyValue(String name) {
        return this.getPropertyValue(name, false);
    }

    @Override
    public <T> T getPropertyValue(String name, boolean old) {
        IDBPropertyDelta propertyDelta = this.getPropertyDelta(name);
        if (propertyDelta == null) {
            return null;
        }
        if (old) {
            return propertyDelta.getOldValue();
        }
        return propertyDelta.getValue();
    }

    @Override
    public final Map<String, IDBPropertyDelta<?>> getPropertyDeltas() {
        return Collections.unmodifiableMap(this.propertyDeltas);
    }

    @Override
    public IDBPropertyDelta<?>[] getPropertyDeltasSortedByName() {
        Object[] result = this.propertyDeltas.values().toArray(new DBPropertyDelta[this.propertyDeltas.size()]);
        Arrays.sort(result);
        return result;
    }

    public final void addPropertyDelta(IDBPropertyDelta<?> propertyDelta) {
        DBDelta parent;
        String name = propertyDelta.getName();
        this.propertyDeltas.put(name, propertyDelta);
        this.resetElements();
        if ("position".equals(name) && (parent = this.getParent()) != null) {
            parent.resetElements();
        }
    }

    @Override
    protected void collectElements(List<IDBDelta> elements) {
        elements.addAll(this.propertyDeltas.values());
    }
}

