/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.ITraversalStrategy;
import org.eclipse.nebula.widgets.nattable.selection.MoveSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;

public class MoveCellSelectionCommandHandler
extends MoveSelectionCommandHandler<MoveSelectionCommand> {
    protected PositionCoordinate lastSelectedCellPosition;
    protected int newSelectedColumnPosition;
    protected int newSelectedRowPosition;

    public MoveCellSelectionCommandHandler(SelectionLayer selectionLayer) {
        super(selectionLayer);
    }

    public MoveCellSelectionCommandHandler(SelectionLayer selectionLayer, ITraversalStrategy traversalStrategy) {
        super(selectionLayer, traversalStrategy);
    }

    public MoveCellSelectionCommandHandler(SelectionLayer selectionLayer, ITraversalStrategy horizontalTraversalStrategy, ITraversalStrategy verticalTraversalStrategy) {
        super(selectionLayer, horizontalTraversalStrategy, verticalTraversalStrategy);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void moveLastSelectedLeft(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        block12: {
            block13: {
                block14: {
                    if (!this.selectionLayer.hasColumnSelection()) break block12;
                    this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
                    lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
                    if (lastSelectedCell == null) break block12;
                    stepSize = traversalStrategy.getStepCount();
                    this.newSelectedColumnPosition = stepSize >= 0 ? lastSelectedCell.getOriginColumnPosition() - stepSize : 0;
                    this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    stopTraversalOnInvalid = false;
                    if (this.newSelectedColumnPosition >= 0) break block13;
                    if (!traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.AXIS)) break block14;
                    if (traversalStrategy.isCycle()) ** GOTO lbl16
                    this.newSelectedColumnPosition = 0;
                    stopTraversalOnInvalid = true;
                    break block13;
lbl-1000:
                    // 1 sources

                    {
                        this.newSelectedColumnPosition += this.selectionLayer.getColumnCount();
lbl16:
                        // 2 sources

                        ** while (this.newSelectedColumnPosition < 0)
                    }
lbl17:
                    // 1 sources

                    break block13;
                }
                if (traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.TABLE)) {
                    rowMove = 0;
                    while (this.newSelectedColumnPosition < 0) {
                        this.newSelectedColumnPosition += this.selectionLayer.getColumnCount();
                        ++rowMove;
                    }
                    this.newSelectedRowPosition -= rowMove;
                    if (this.newSelectedRowPosition < 0) {
                        if (traversalStrategy.isCycle()) {
                            this.newSelectedRowPosition += this.selectionLayer.getRowCount();
                        } else {
                            this.newSelectedColumnPosition = 0;
                            this.newSelectedRowPosition = 0;
                            stopTraversalOnInvalid = true;
                        }
                    }
                }
            }
            if (this.positionMoved()) {
                if (!traversalStrategy.isValidTarget(lastSelectedCell, this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition))) {
                    if (!stopTraversalOnInvalid) {
                        this.moveLastSelectedLeft(this.createIncrementalStrategy(traversalStrategy), withShiftMask, withControlMask);
                    } else {
                        this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                        this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    }
                } else {
                    if (stepSize == -1 && !withShiftMask) {
                        this.selectionLayer.clear(false);
                    }
                    this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                    this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, true, withShiftMask, withControlMask);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void moveLastSelectedRight(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        block12: {
            block13: {
                block14: {
                    if (!this.selectionLayer.hasColumnSelection()) break block12;
                    this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
                    lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
                    if (lastSelectedCell == null) break block12;
                    stepSize = traversalStrategy.getStepCount();
                    this.newSelectedColumnPosition = stepSize >= 0 ? lastSelectedCell.getOriginColumnPosition() + lastSelectedCell.getColumnSpan() - 1 + stepSize : this.selectionLayer.getColumnCount() - 1;
                    this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    stopTraversalOnInvalid = false;
                    if (this.newSelectedColumnPosition < this.selectionLayer.getColumnCount()) break block13;
                    if (!traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.AXIS)) break block14;
                    if (traversalStrategy.isCycle()) ** GOTO lbl16
                    this.newSelectedColumnPosition = this.selectionLayer.getColumnCount() - 1;
                    stopTraversalOnInvalid = true;
                    break block13;
lbl-1000:
                    // 1 sources

                    {
                        this.newSelectedColumnPosition -= this.selectionLayer.getColumnCount();
lbl16:
                        // 2 sources

                        ** while (this.newSelectedColumnPosition >= this.selectionLayer.getColumnCount())
                    }
lbl17:
                    // 1 sources

                    break block13;
                }
                if (traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.TABLE)) {
                    rowMove = 0;
                    while (this.newSelectedColumnPosition >= this.selectionLayer.getColumnCount()) {
                        this.newSelectedColumnPosition -= this.selectionLayer.getColumnCount();
                        ++rowMove;
                    }
                    this.newSelectedRowPosition += rowMove;
                    if (this.newSelectedRowPosition >= this.selectionLayer.getRowCount()) {
                        if (traversalStrategy.isCycle()) {
                            this.newSelectedRowPosition -= this.selectionLayer.getRowCount();
                        } else {
                            this.newSelectedColumnPosition = this.selectionLayer.getColumnCount() - 1;
                            this.newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
                            stopTraversalOnInvalid = true;
                        }
                    }
                }
            }
            if (this.positionMoved()) {
                if (stepSize == -1 && !withShiftMask) {
                    this.selectionLayer.clear(false);
                }
                if (!traversalStrategy.isValidTarget(lastSelectedCell, this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition))) {
                    if (!stopTraversalOnInvalid) {
                        this.moveLastSelectedRight(this.createIncrementalStrategy(traversalStrategy), withShiftMask, withControlMask);
                    } else {
                        this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                        this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    }
                } else {
                    this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                    this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, true, withShiftMask, withControlMask);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void moveLastSelectedUp(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        block11: {
            block12: {
                block13: {
                    if (!this.selectionLayer.hasRowSelection()) break block11;
                    this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
                    lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
                    if (lastSelectedCell == null) break block11;
                    stepSize = traversalStrategy.getStepCount();
                    this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                    this.newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.getOriginRowPosition() - stepSize : 0;
                    stopTraversalOnInvalid = false;
                    if (this.newSelectedRowPosition >= 0) break block12;
                    if (!traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.AXIS)) break block13;
                    if (traversalStrategy.isCycle()) ** GOTO lbl16
                    this.newSelectedRowPosition = 0;
                    stopTraversalOnInvalid = true;
                    break block12;
lbl-1000:
                    // 1 sources

                    {
                        this.newSelectedRowPosition += this.selectionLayer.getRowCount();
lbl16:
                        // 2 sources

                        ** while (this.newSelectedRowPosition < 0)
                    }
lbl17:
                    // 1 sources

                    break block12;
                }
                if (traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.TABLE)) {
                    columnMove = 0;
                    while (this.newSelectedRowPosition < 0) {
                        this.newSelectedRowPosition += this.selectionLayer.getRowCount();
                        ++columnMove;
                    }
                    this.newSelectedColumnPosition -= columnMove;
                    if (this.newSelectedColumnPosition < 0) {
                        if (traversalStrategy.isCycle()) {
                            this.newSelectedColumnPosition += this.selectionLayer.getColumnCount();
                        } else {
                            this.newSelectedColumnPosition = 0;
                            this.newSelectedRowPosition = 0;
                            stopTraversalOnInvalid = true;
                        }
                    }
                }
            }
            if (this.positionMoved()) {
                if (!traversalStrategy.isValidTarget(lastSelectedCell, this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition))) {
                    if (!stopTraversalOnInvalid) {
                        this.moveLastSelectedUp(this.createIncrementalStrategy(traversalStrategy), withShiftMask, withControlMask);
                    } else {
                        this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                        this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    }
                } else {
                    this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                    this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, true, withShiftMask, withControlMask);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void moveLastSelectedDown(ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        block11: {
            block12: {
                block13: {
                    if (!this.selectionLayer.hasRowSelection()) break block11;
                    this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
                    lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
                    if (lastSelectedCell == null) break block11;
                    stepSize = traversalStrategy.getStepCount();
                    this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                    this.newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.getOriginRowPosition() + lastSelectedCell.getRowSpan() - 1 + stepSize : this.selectionLayer.getRowCount() - 1;
                    stopTraversalOnInvalid = false;
                    if (this.newSelectedRowPosition < this.selectionLayer.getRowCount()) break block12;
                    if (!traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.AXIS)) break block13;
                    if (traversalStrategy.isCycle()) ** GOTO lbl16
                    this.newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
                    stopTraversalOnInvalid = true;
                    break block12;
lbl-1000:
                    // 1 sources

                    {
                        this.newSelectedRowPosition -= this.selectionLayer.getRowCount();
lbl16:
                        // 2 sources

                        ** while (this.newSelectedRowPosition >= this.selectionLayer.getRowCount())
                    }
lbl17:
                    // 1 sources

                    break block12;
                }
                if (traversalStrategy.getTraversalScope().equals((Object)ITraversalStrategy.TraversalScope.TABLE)) {
                    columnMove = 0;
                    while (this.newSelectedRowPosition >= this.selectionLayer.getRowCount()) {
                        this.newSelectedRowPosition -= this.selectionLayer.getRowCount();
                        ++columnMove;
                    }
                    this.newSelectedColumnPosition += columnMove;
                    if (this.newSelectedColumnPosition >= this.selectionLayer.getColumnCount()) {
                        if (traversalStrategy.isCycle()) {
                            this.newSelectedColumnPosition -= this.selectionLayer.getColumnCount();
                        } else {
                            this.newSelectedColumnPosition = this.selectionLayer.getColumnCount() - 1;
                            this.newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
                            stopTraversalOnInvalid = true;
                        }
                    }
                }
            }
            if (this.positionMoved()) {
                if (!traversalStrategy.isValidTarget(lastSelectedCell, this.selectionLayer.getCellByPosition(this.newSelectedColumnPosition, this.newSelectedRowPosition))) {
                    if (!stopTraversalOnInvalid) {
                        this.moveLastSelectedDown(this.createIncrementalStrategy(traversalStrategy), withShiftMask, withControlMask);
                    } else {
                        this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
                        this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
                    }
                } else {
                    this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                    this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, true, withShiftMask, withControlMask);
                }
            }
        }
    }

    protected ITraversalStrategy createIncrementalStrategy(final ITraversalStrategy baseStrategy) {
        return new ITraversalStrategy(){

            @Override
            public ITraversalStrategy.TraversalScope getTraversalScope() {
                return baseStrategy.getTraversalScope();
            }

            @Override
            public boolean isCycle() {
                return baseStrategy.isCycle();
            }

            @Override
            public int getStepCount() {
                return baseStrategy.getStepCount() + 1;
            }

            @Override
            public boolean isValidTarget(ILayerCell from, ILayerCell to) {
                return baseStrategy.isValidTarget(from, to);
            }
        };
    }

    protected boolean positionMoved() {
        return this.newSelectedColumnPosition != this.lastSelectedCellPosition.columnPosition || this.newSelectedRowPosition != this.lastSelectedCellPosition.rowPosition;
    }

    @Override
    public Class<MoveSelectionCommand> getCommandClass() {
        return MoveSelectionCommand.class;
    }
}

