/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.m2m.internal.qvt.oml.common.ui.CommonPluginImages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider.EMFLabelProvider;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.TraceViewContentProvider;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.presentation.Node;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingOperation;
import org.eclipse.m2m.internal.qvt.oml.trace.ETuplePartValue;
import org.eclipse.m2m.internal.qvt.oml.trace.EValue;
import org.eclipse.m2m.internal.qvt.oml.trace.TracePackage;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceRecord;
import org.eclipse.m2m.internal.qvt.oml.trace.VarParameterValue;
import org.eclipse.swt.graphics.Image;

public class TraceViewLabelProvider
extends EMFLabelProvider {
    private final AdapterFactoryLabelProvider myLabelProvider;
    private boolean isQualified;
    private final List<Image> myImageCache = new ArrayList<Image>(2);

    public TraceViewLabelProvider() {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.myLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
    }

    public String getText(Object element) {
        if (element instanceof TraceRecord) {
            TraceRecord traceRecord = (TraceRecord)element;
            StringBuffer result = new StringBuffer();
            EMappingOperation mappingOperation = traceRecord.getMappingOperation();
            if (this.isQualified) {
                if (mappingOperation.getPackage().length() != 0) {
                    result.append(String.valueOf(mappingOperation.getPackage()) + '.');
                }
                result.append(String.valueOf(mappingOperation.getModule()) + '.');
            }
            result.append(mappingOperation.getName());
            result.append(" (");
            if (traceRecord.getContext().getContext() != null) {
                result.append("SELF: " + TraceViewLabelProvider.getValue(traceRecord.getContext().getContext().getValue()));
            }
            this.appendValueList((EList<VarParameterValue>)traceRecord.getParameters().getParameters(), "PARAMS", result);
            this.appendValueList((EList<VarParameterValue>)traceRecord.getResult().getResult(), "RESULT", result);
            result.append(")");
            return result.toString();
        }
        if (element instanceof VarParameterValue) {
            VarParameterValue varParameterValue = (VarParameterValue)element;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.valueOf(varParameterValue.getKind().getLiteral().toLowerCase()) + ' ');
            stringBuffer.append(String.valueOf(varParameterValue.getName()) + " : ");
            stringBuffer.append(String.valueOf(varParameterValue.getType()) + " = ");
            stringBuffer.append(TraceViewLabelProvider.getValue(varParameterValue.getValue()));
            return stringBuffer.toString();
        }
        if (element instanceof EValue) {
            return TraceViewLabelProvider.getValue((EValue)element);
        }
        if (element instanceof Node) {
            Object object = ((Node)element).getObject();
            String text = this.myLabelProvider.getText(object);
            if (this.isContainedByTrace(object)) {
                text = "[unbound] " + text;
            }
            return text;
        }
        throw new RuntimeException("Unknown input:" + element.getClass());
    }

    public Image getImage(Object element) {
        if (element instanceof TraceRecord) {
            Object[] elements;
            Image img = this.myLabelProvider.getImage(element);
            Object[] objectArray = elements = new TraceViewContentProvider().getElements((TraceRecord)element);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                Image newImage = this.getVarParameterImage(img, (VarParameterValue)obj);
                if (newImage != img) {
                    return newImage;
                }
                ++n2;
            }
            return img;
        }
        if (element instanceof VarParameterValue) {
            return this.getVarParameterImage(this.myLabelProvider.getImage(element), (VarParameterValue)element);
        }
        if (element instanceof Node) {
            Object object = ((Node)element).getObject();
            Image img = this.myLabelProvider.getImage(object);
            if (this.isContainedByTrace(object)) {
                return this.getDecoratedImage(img, "warning-co");
            }
            return img;
        }
        return this.myLabelProvider.getImage(element);
    }

    private Image getVarParameterImage(Image baseImage, VarParameterValue varParamV) {
        EObject modelElement;
        if (varParamV.getValue() != null && varParamV.getValue().getModelElement() != null && this.isContainedByTrace(modelElement = varParamV.getValue().getModelElement())) {
            return this.getDecoratedImage(baseImage, "warning-co");
        }
        return baseImage;
    }

    public void setShowQualifiedNames(boolean isOn) {
        this.isQualified = isOn;
    }

    public void dispose() {
        for (Image img : this.myImageCache) {
            img.dispose();
        }
        super.dispose();
    }

    private void appendValueList(EList<VarParameterValue> valueList, String prefix, StringBuffer result) {
        int size = valueList.size();
        if (size > 0) {
            if (result.charAt(result.length() - 1) != '(') {
                result.append(", ");
            }
            result.append(String.valueOf(prefix) + ": ");
            int i = 0;
            int n = size - 1;
            while (i < n) {
                result.append(String.valueOf(TraceViewLabelProvider.getValue(((VarParameterValue)valueList.get(i)).getValue())) + ", ");
                ++i;
            }
            result.append(TraceViewLabelProvider.getValue(((VarParameterValue)valueList.get(size - 1)).getValue()));
        }
    }

    private static String getValue(EValue eValue) {
        if (eValue instanceof ETuplePartValue) {
            ETuplePartValue tuplePartValue = (ETuplePartValue)eValue;
            return String.valueOf('[') + tuplePartValue.getName() + "]: " + TraceViewLabelProvider.getValue(tuplePartValue.getValue());
        }
        if (eValue.getModelElement() != null) {
            return eValue.getModelElement().eClass().getName();
        }
        if (eValue.getPrimitiveValue() != null) {
            return eValue.getPrimitiveValue();
        }
        if (eValue.getIntermediateElement() != null) {
            return eValue.getIntermediateElement().eClass().getName();
        }
        if (!eValue.getCollection().isEmpty()) {
            return String.valueOf(eValue.getCollectionType()) + '[' + eValue.getCollection().size() + ']';
        }
        return "null";
    }

    private boolean isContainedByTrace(Object element) {
        if (!(element instanceof EObject)) {
            return false;
        }
        return EcoreUtil.getRootContainer((EObject)((EObject)element)).eClass().eContainer() == TracePackage.eINSTANCE;
    }

    private Image getDecoratedImage(Image baseImage, String decoratorKey) {
        ImageDescriptor decoratorId = CommonPluginImages.getInstance().getImageDescriptor(decoratorKey);
        DecorationOverlayIcon decoratedIconId = new DecorationOverlayIcon(baseImage, decoratorId, 0);
        Image decoratedImage = decoratedIconId.createImage();
        this.myImageCache.add(decoratedImage);
        return decoratedImage;
    }
}

