/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecEnvPool {
    private final Map<String, Metamodel> metamodels = new LinkedHashMap<String, Metamodel>();
    private ModuleResolverFactory moduleResolverFactory;
    private final List<String> modules = new ArrayList<String>();
    private boolean frozen;
    private final Collection<SoftReference<ExecEnv>> pool = new LinkedList<SoftReference<ExecEnv>>();
    private final Queue<SoftReference<ExecEnv>> freePool = new LinkedList<SoftReference<ExecEnv>>();

    public synchronized void registerMetaModel(String name, Metamodel metamodel) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot register metamodels after calling getExecEnv()");
        }
        this.metamodels.put(name, metamodel);
    }

    public synchronized void loadModule(String name) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot load modules after calling getExecEnv()");
        }
        this.modules.add(name);
    }

    public synchronized ExecEnv getExecEnv() {
        boolean validate = !this.isFrozen();
        this.setFrozen(true);
        Queue<SoftReference<ExecEnv>> freePool = this.getFreePool();
        ExecEnv execEnv = null;
        while (!freePool.isEmpty() && execEnv == null) {
            execEnv = freePool.poll().get();
        }
        if (execEnv == null) {
            execEnv = EmftvmFactory.eINSTANCE.createExecEnv();
            for (Map.Entry<String, Metamodel> metamodel : this.getMetamodels().entrySet()) {
                execEnv.registerMetaModel(metamodel.getKey(), metamodel.getValue());
            }
            ModuleResolverFactory moduleResolverFactory = this.getModuleResolverFactory();
            List<String> modules = this.getModules();
            if (!modules.isEmpty()) {
                if (moduleResolverFactory == null) {
                    throw new IllegalStateException("No module resolver factory set");
                }
                ModuleResolver moduleResolver = moduleResolverFactory.createModuleResolver();
                for (String module : this.getModules()) {
                    execEnv.loadModule(moduleResolver, module, validate);
                }
            }
            this.getPool().add(new SoftReference<ExecEnv>(execEnv));
        }
        return execEnv;
    }

    public synchronized void returnExecEnv(ExecEnv env) {
        boolean found = false;
        Iterator<SoftReference<ExecEnv>> it = this.getPool().iterator();
        while (it.hasNext()) {
            ExecEnv envEntry = it.next().get();
            if (envEntry == null) {
                it.remove();
                continue;
            }
            found |= env == envEntry;
        }
        if (!found) {
            throw new IllegalArgumentException(String.format("%s was not created by this pool", env));
        }
        boolean freeFound = false;
        Iterator it2 = this.getFreePool().iterator();
        while (it2.hasNext()) {
            ExecEnv envEntry = (ExecEnv)((SoftReference)it2.next()).get();
            if (envEntry == null) {
                it2.remove();
                continue;
            }
            freeFound |= env == envEntry;
        }
        if (!freeFound) {
            env.clearModels();
            this.getFreePool().offer(new SoftReference<ExecEnv>(env));
        }
    }

    public synchronized boolean isFrozen() {
        return this.frozen;
    }

    protected void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    protected Map<String, Metamodel> getMetamodels() {
        return this.metamodels;
    }

    protected ModuleResolverFactory getModuleResolverFactory() {
        return this.moduleResolverFactory;
    }

    public synchronized void setModuleResolverFactory(ModuleResolverFactory moduleResolverFactory) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot load modules after calling getExecEnv()");
        }
        this.moduleResolverFactory = moduleResolverFactory;
    }

    protected List<String> getModules() {
        return this.modules;
    }

    protected Collection<SoftReference<ExecEnv>> getPool() {
        return this.pool;
    }

    protected Queue<SoftReference<ExecEnv>> getFreePool() {
        return this.freePool;
    }
}

