/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.listener;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.linuxtools.internal.rpm.createrepo.Activator;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProject;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public class CreaterepoResourceChangeListener
implements IResourceChangeListener {
    private CreaterepoProject project;

    public CreaterepoResourceChangeListener(CreaterepoProject project) {
        this.project = project;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: 
            case 2: 
            case 4: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(this::closeEditors);
            }
        }
    }

    private void closeEditors() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IFile repomdFile = this.project.getRepoFile();
        if (!repomdFile.exists()) {
            IWorkbenchPage[] iWorkbenchPageArray = workbench.getActiveWorkbenchWindow().getPages();
            int n = iWorkbenchPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n3 = iEditorReferenceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference ref = iEditorReferenceArray[n4];
                    try {
                        IResource resource = ResourceUtil.getResource((IEditorInput)ref.getEditorInput());
                        if (ref.getId().equals("org.eclipse.linuxtools.rpm.createrepo.repoEditor") && resource.getProject().equals((Object)this.project.getProject())) {
                            page.closeEditor(ref.getEditor(false), false);
                        }
                    }
                    catch (PartInitException e) {
                        Activator.logError(Messages.CreaterepoResourceChangeListener_errorGettingResource, e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

