/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtilities {
    private static final String JAR_PREFIX = "jar:";
    private static final String JAR_FILE_PREFIX = "jar:file:";
    public static final JarUtilities INSTANCE = new JarUtilities();

    public URL createJarUrl(JarFile jarFile) throws MalformedURLException {
        return this.createJarUrl(jarFile, "");
    }

    public URL createJarUrl(JarFile jarFile, JarEntry jarEntry) throws MalformedURLException {
        return this.createJarUrl(jarFile, jarEntry != null ? jarEntry.getName() : "");
    }

    public URL createJarUrl(JarFile jarFile, String jarEntryName) throws MalformedURLException {
        String fixedJarFileName = jarFile.getName().replace("\\", "/");
        return this.createJarUrl(fixedJarFileName, jarEntryName != null ? jarEntryName : "");
    }

    public URL createJarUrl(String filePath, String jarEntryName) throws MalformedURLException {
        String urlString = String.format("jar:file:///%s!/%s", filePath, jarEntryName);
        return new URL(urlString);
    }

    public File getFile(URL url) {
        String string = url.toString();
        if (string != null && string.startsWith(JAR_FILE_PREFIX)) {
            string = string.substring(JAR_PREFIX.length());
            try {
                return new File(URI.create(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }
}

