/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.bazaar.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emfforms.bazaar.Bazaar;
import org.eclipse.emfforms.bazaar.BazaarContext;
import org.eclipse.emfforms.bazaar.BazaarContextFunction;
import org.eclipse.emfforms.bazaar.Vendor;
import org.eclipse.emfforms.bazaar.internal.BazaarImpl;

public final class ThreadSafeBazaar<T>
extends BazaarImpl<T> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ThreadSafeBazaar() {
    }

    public ThreadSafeBazaar(Collection<? extends Vendor<? extends T>> vendors, Map<String, ? extends BazaarContextFunction> contextFunctions, Bazaar.PriorityOverlapCallBack<? super T> priorityOverlapCallBack) {
        if (vendors != null) {
            for (Vendor vendor : vendors) {
                super.addVendor(vendor);
            }
        }
        if (contextFunctions != null) {
            for (Map.Entry entry : contextFunctions.entrySet()) {
                super.addContextFunction((String)entry.getKey(), (BazaarContextFunction)entry.getValue());
            }
        }
        super.setPriorityOverlapCallBack(priorityOverlapCallBack);
    }

    @Override
    public T createProduct(BazaarContext bazaarContext) {
        this.lock.readLock().lock();
        try {
            Object t = super.createProduct(bazaarContext);
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<T> createProducts(BazaarContext bazaarContext) {
        this.lock.readLock().lock();
        try {
            List list = super.createProducts(bazaarContext);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void addVendor(Vendor<? extends T> vendor) {
        this.lock.writeLock().lock();
        try {
            super.addVendor(vendor);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeVendor(Vendor<? extends T> vendor) {
        this.lock.writeLock().lock();
        try {
            super.removeVendor(vendor);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void addContextFunction(String key, BazaarContextFunction contextFunction) {
        this.lock.writeLock().lock();
        try {
            super.addContextFunction(key, contextFunction);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setPriorityOverlapCallBack(Bazaar.PriorityOverlapCallBack<? super T> priorityOverlapCallBack) {
        this.lock.writeLock().lock();
        try {
            super.setPriorityOverlapCallBack(priorityOverlapCallBack);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

