/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;

public class CompoundModelMinimizer
implements IModelMinimizer {
    protected List<IModelMinimizer> minimizers;

    public CompoundModelMinimizer(IModelMinimizer ... minimizers) {
        this(Arrays.asList(minimizers));
    }

    public CompoundModelMinimizer(List<IModelMinimizer> minimizers) {
        this.minimizers = minimizers == null ? Lists.newArrayList() : minimizers;
    }

    @Override
    public void minimize(SynchronizationModel syncModel, IProgressMonitor monitor) {
        for (IModelMinimizer minimizer : this.minimizers) {
            minimizer.minimize(syncModel, monitor);
        }
    }

    @Override
    public void minimize(IFile file, SynchronizationModel syncModel, IProgressMonitor monitor) {
        for (IModelMinimizer minimizer : this.minimizers) {
            minimizer.minimize(file, syncModel, monitor);
        }
    }
}

