/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.xml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.internal.core.utils.xml.IModelChangedListener;
import org.eclipse.wb.internal.core.utils.xml.ModelChangedEvent;

public final class Model {
    private String m_charset;
    private final List<IModelChangedListener> m_listeners = Lists.newArrayList();

    public void setCharset(String charset) {
        this.m_charset = charset;
    }

    public String getCharset() {
        return this.m_charset;
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        this.m_listeners.remove(listener);
    }

    public void fireModelChanged(ModelChangedEvent event) {
        ArrayList listeners = Lists.newArrayList(this.m_listeners);
        for (IModelChangedListener listener : listeners) {
            listener.modelChanged(event);
        }
    }
}

