/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.variable.AbstractNoNameVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public final class ExposedFieldVariableSupport
extends AbstractNoNameVariableSupport {
    private final JavaInfo m_hostJavaInfo;
    private final Field m_field;

    public ExposedFieldVariableSupport(JavaInfo javaInfo, JavaInfo hostJavaInfo, Field field) {
        super(javaInfo);
        this.m_hostJavaInfo = hostJavaInfo;
        this.m_field = field;
    }

    public String toString() {
        return this.m_field.getName();
    }

    @Override
    public boolean isValidStatementForChild(Statement statement) {
        return this.m_hostJavaInfo.getVariableSupport().isValidStatementForChild(statement);
    }

    @Override
    public String getTitle() throws Exception {
        return this.m_field.getName();
    }

    @Override
    public String getComponentName() {
        String name = this.m_field.getName();
        name = new VariableUtils(this.m_javaInfo).stripPrefixSuffix(name, "org.eclipse.jdt.core.codeComplete.fieldPrefixes", "org.eclipse.jdt.core.codeComplete.fieldSuffixes");
        name = StringUtils.capitalize((String)name);
        return String.valueOf(this.m_hostJavaInfo.getVariableSupport().getComponentName()) + name;
    }

    @Override
    public boolean hasExpression(NodeTarget target) {
        return this.m_hostJavaInfo.getVariableSupport().hasExpression(target);
    }

    @Override
    public String getReferenceExpression(NodeTarget target) throws Exception {
        String parentAccess = this.m_hostJavaInfo.getVariableSupport().getAccessExpression(target);
        return String.valueOf(parentAccess) + this.m_field.getName();
    }

    @Override
    public String getAccessExpression(NodeTarget target) throws Exception {
        return String.valueOf(this.getReferenceExpression(target)) + ".";
    }

    @Override
    public StatementTarget getStatementTarget() throws Exception {
        return this.m_hostJavaInfo.getVariableSupport().getStatementTarget();
    }

    @Override
    public StatementTarget getChildTarget() throws Exception {
        return JavaInfoUtils.getTarget(this.m_hostJavaInfo);
    }
}

