/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.internal.rdt.sync.cdt.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.messages.Messages;

public class WizardUtil {
    private static final String SYNC_BUILDER_CLASS = "org.eclipse.ptp.rdt.sync.cdt.core.SyncBuilder";
    private static final Map<String, String> languageSettingsProviderReplacementsMap = new HashMap<String, String>();

    public static void modifyBuildConfigForSync(IConfiguration buildConfig) {
        IBuilder syncBuilder = ManagedBuildManager.getExtensionBuilder((String)SYNC_BUILDER_CLASS);
        buildConfig.changeBuilder(syncBuilder, SYNC_BUILDER_CLASS, Messages.WizardUtil_0);
        ManagedBuildManager.saveBuildInfo((IProject)buildConfig.getOwner().getProject(), (boolean)true);
    }

    public static void modifyLocalBuildConfigForSync(IConfiguration buildConfig) {
    }

    public static void modifyRemoteBuildConfigForSync(IConfiguration buildConfig) {
        ICConfigurationDescription c_mb_confgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)buildConfig);
        if (c_mb_confgDes != null) {
            EnvironmentVariableManager.fUserSupplier.setAppendContributedEnvironment(false, (Object)c_mb_confgDes);
        }
        ManagedBuildManager.saveBuildInfo((IProject)buildConfig.getOwner().getProject(), (boolean)true);
        ICProjectDescription projectDesc = CoreModel.getDefault().getProjectDescription(buildConfig.getOwner().getProject());
        ICConfigurationDescription configDesc = projectDesc.getConfigurationById(buildConfig.getId());
        if (configDesc == null) {
            Activator.log((String)(String.valueOf(Messages.WizardUtil_1) + buildConfig.getName()));
        }
        ILanguageSettingsProvidersKeeper lspk = (ILanguageSettingsProvidersKeeper)configDesc;
        List oldProviders = lspk.getLanguageSettingProviders();
        ArrayList<ILanguageSettingsProvider> newProviders = new ArrayList<ILanguageSettingsProvider>();
        for (ILanguageSettingsProvider p : oldProviders) {
            if (languageSettingsProviderReplacementsMap.containsKey(p.getId())) {
                String replacementId = languageSettingsProviderReplacementsMap.get(p.getId());
                if (replacementId == null) continue;
                p = LanguageSettingsManager.getExtensionProviderCopy((String)replacementId, (boolean)false);
            }
            newProviders.add(p);
        }
        lspk.setLanguageSettingProviders(newProviders);
        buildConfig.setDirty(true);
        WizardUtil.setProjectDescription(buildConfig.getOwner().getProject(), projectDesc);
    }

    public static void setProjectDescription(final IProject project, final ICProjectDescription desc) {
        CoreException firstException = null;
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            if (!ws.isTreeLocked()) {
                CoreModel.getDefault().setProjectDescription(project, desc, true, null);
                return;
            }
        }
        catch (CoreException e) {
            firstException = e;
        }
        final CoreException currentException = firstException;
        Thread flushThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int sleepCount = 0;
                Throwable lastException = currentException;
                block3: while (true) {
                    try {
                        do {
                            Thread.sleep(1000L);
                            if (++sleepCount <= 30) continue;
                            if (lastException != null) {
                                Activator.log((String)Messages.WizardUtil_2, (Throwable)lastException);
                                break block3;
                            }
                            Activator.log((String)Messages.WizardUtil_2);
                            break block3;
                        } while (ws.isTreeLocked());
                        CoreModel.getDefault().setProjectDescription(project, desc, true, null);
                    }
                    catch (InterruptedException e) {
                        lastException = e;
                        continue;
                    }
                    catch (CoreException e) {
                        lastException = e;
                        continue;
                    }
                    break;
                }
            }
        }, "Save project CDT data thread");
        flushThread.start();
    }
}

