/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantConnection;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.vagrant.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.AddBoxWizard;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.WizardMessages;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.VagrantException;
import org.eclipse.linuxtools.vagrant.core.VagrantService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddBoxCommandHandler
extends AbstractHandler {
    private static final String PULL_IMAGE_JOB_TITLE = "ImagePull.title";
    private static final String PULL_IMAGE_JOB_TASK = "ImagePull.msg";
    private static final String ERROR_PULLING_IMAGE = "ImagePullError.msg";

    public Object execute(ExecutionEvent event) {
        if (VagrantConnection.findVagrantPath() == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)WizardMessages.getString("VagrantCommandNotFound.title"), (String)WizardMessages.getString("VagrantCommandNotFound.msg")));
        } else {
            AddBoxWizard wizard = new AddBoxWizard();
            boolean pullImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (pullImage) {
                this.performPullImage(wizard.getBoxName(), wizard.getBoxLoc());
            }
        }
        return null;
    }

    private void performPullImage(final String boxName, final String boxLoc) {
        Job pullImageJob = new Job(DVMessages.getFormattedString(PULL_IMAGE_JOB_TITLE, boxName)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(AddBoxCommandHandler.PULL_IMAGE_JOB_TASK), -1);
                try {
                    try {
                        IVagrantConnection connection = VagrantService.getInstance();
                        boolean isValidURL = true;
                        try {
                            new URL(boxLoc);
                        }
                        catch (MalformedURLException e) {
                            isValidURL = false;
                        }
                        connection.addBox(boxName, boxLoc, isValidURL);
                        connection.getBoxes(true);
                    }
                    catch (VagrantException e) {
                        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(AddBoxCommandHandler.ERROR_PULLING_IMAGE, boxName), (String)e.getMessage()));
                        monitor.done();
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        pullImageJob.schedule();
    }
}

