/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.range.RangeModeCommand;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ApplyStyleCommand
extends RangeModeCommand {
    private String _tag;
    private String _cssProperty;
    private String _cssPropertyValue;
    private final Element _applyingNode;

    public ApplyStyleCommand(IHTMLGraphicalViewer viewer, String tag, String property, String value) {
        super(CommandResources.getString("ApplyStyleCommand.Label.ApplyStyle"), viewer);
        this._tag = tag;
        this._cssProperty = property;
        this._cssPropertyValue = value;
        this._applyingNode = null;
    }

    public ApplyStyleCommand(IHTMLGraphicalViewer viewer, Element node, String property, String value) {
        super(CommandResources.getString("ApplyStyleCommand.Label.ApplyStyle"), viewer);
        this._applyingNode = node;
    }

    protected final Element getApplyingNode() {
        return this._applyingNode;
    }

    protected DOMRange doRangeExecute(DOMRange range) {
        if (range == null || range.isEmpty()) {
            return null;
        }
        boolean ordered = range.isOrdered();
        IDOMPosition start = ordered ? range.getStartPosition() : range.getEndPosition();
        IDOMPosition end = ordered ? range.getEndPosition() : range.getStartPosition();
        Node startContainer = start.getContainerNode();
        Node endContainer = end.getContainerNode();
        Node common = DOMUtil.findCommonAncester(start.getContainerNode(), end.getContainerNode());
        if (common == null) {
            return null;
        }
        if (common instanceof Text) {
            range = this.doTextNodeStyleApply((Text)common, start.getOffset(), end.getOffset());
            return range;
        }
        if (startContainer instanceof Text) {
            if (start.getOffset() > 0) {
                startContainer = ((Text)startContainer).splitText(start.getOffset());
                start = new DOMRefPosition(startContainer, false);
            }
        } else {
            startContainer = start.getNextSiblingNode();
        }
        if (endContainer instanceof Text) {
            if (end.getOffset() > 0) {
                endContainer = ((Text)endContainer).splitText(end.getOffset());
                endContainer = endContainer.getPreviousSibling();
            } else {
                endContainer = endContainer.getPreviousSibling();
            }
        } else {
            endContainer = end.getPreviousSiblingNode();
        }
        Node node = startContainer;
        while (node != endContainer) {
            if (!EditModelQuery.hasAncestor(node, this.getTag(), true)) {
                Element newnode = this.createStyleElement();
                node.getParentNode().insertBefore(newnode, node);
                newnode.appendChild(node);
            }
            node = EditModelQuery.getInstance().getNextLeafNeighbor(node);
        }
        if (!EditModelQuery.hasAncestor(endContainer, this.getTag(), true)) {
            Element newnode = this.createStyleElement();
            endContainer.getParentNode().insertBefore(newnode, endContainer);
            newnode.appendChild(endContainer);
        }
        node = startContainer;
        while (node != endContainer) {
            Node stylenode = node;
            while (stylenode != null && !stylenode.getNodeName().equalsIgnoreCase(this.getTag())) {
                stylenode = stylenode.getParentNode();
            }
            if (stylenode != null && stylenode.getNextSibling() != null && stylenode.getNextSibling().getNodeName().equalsIgnoreCase(this.getTag())) {
                Node sibling = stylenode.getNextSibling();
                while (sibling.getFirstChild() != null) {
                    stylenode.appendChild(sibling.getFirstChild());
                }
                stylenode.getParentNode().removeChild(sibling);
                node = startContainer;
            }
            node = EditModelQuery.getInstance().getNextLeafNeighbor(node);
        }
        return new DOMRange(start, end);
    }

    private DOMRange doTextNodeStyleApply(Text textNode, int startOffset, int endOffset) {
        Element bnode;
        Node sibling;
        Element bnode2;
        String data = textNode.getData();
        String before = data.substring(0, startOffset);
        String middle = data.substring(startOffset, endOffset);
        String tail = data.substring(endOffset);
        Text middleText = this.getModel().getDocument().createTextNode(middle);
        if (!this.isEmptyString(before) && !this.isEmptyString(tail)) {
            Node parent = textNode.getParentNode();
            parent.insertBefore(this.getModel().getDocument().createTextNode(before), textNode);
            bnode2 = this.createStyleElement();
            bnode2.appendChild(middleText);
            parent.insertBefore(bnode2, textNode);
            textNode.setNodeValue(tail);
        }
        if (this.isEmptyString(before) && !this.isEmptyString(tail)) {
            sibling = textNode.getPreviousSibling();
            if (sibling != null && sibling.getNodeName().equalsIgnoreCase(this.getTag())) {
                sibling.appendChild(middleText);
            } else {
                Node parent = textNode.getParentNode();
                parent.insertBefore(this.getModel().getDocument().createTextNode(before), textNode);
                bnode = this.createStyleElement();
                bnode.appendChild(middleText);
                parent.insertBefore(bnode, textNode);
            }
            textNode.setNodeValue(tail);
        }
        if (!this.isEmptyString(before) && this.isEmptyString(tail)) {
            sibling = textNode.getNextSibling();
            textNode.setNodeValue(before);
            if (sibling != null && sibling.getNodeName().equalsIgnoreCase(this.getTag())) {
                sibling.insertBefore(middleText, sibling.getFirstChild());
            } else {
                bnode2 = this.createStyleElement();
                bnode2.appendChild(middleText);
                textNode.getParentNode().insertBefore(bnode2, sibling);
            }
        }
        if (this.isEmptyString(before) && this.isEmptyString(tail)) {
            Node previousSibling = textNode.getPreviousSibling();
            Node nextSibling = textNode.getNextSibling();
            if (this.getTag().equalsIgnoreCase("p")) {
                bnode = this.createStyleElement();
                bnode.appendChild(middleText);
                textNode.getParentNode().insertBefore(bnode, textNode);
                textNode.getParentNode().removeChild(textNode);
            } else {
                if (previousSibling != null && previousSibling.getNodeName().equalsIgnoreCase(this.getTag()) && nextSibling != null && nextSibling.getNodeName().equalsIgnoreCase(this.getTag())) {
                    previousSibling.appendChild(middleText);
                    while (nextSibling.getFirstChild() != null) {
                        previousSibling.appendChild(nextSibling.getFirstChild());
                    }
                    nextSibling.getParentNode().removeChild(nextSibling);
                } else if (previousSibling != null && previousSibling.getNodeName().equalsIgnoreCase(this.getTag())) {
                    previousSibling.appendChild(middleText);
                } else if (nextSibling != null && nextSibling.getNodeName().equalsIgnoreCase(this.getTag())) {
                    nextSibling.insertBefore(middleText, nextSibling.getFirstChild());
                } else {
                    bnode = this.createStyleElement();
                    bnode.appendChild(middleText);
                    textNode.getParentNode().insertBefore(bnode, textNode);
                }
                textNode.getParentNode().removeChild(textNode);
            }
        }
        return new DOMRange(new DOMRefPosition(middleText, false), new DOMRefPosition(middleText, true));
    }

    private boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }

    protected Element createStyleElement() {
        if (this._applyingNode != null) {
            return this._applyingNode;
        }
        Element element = this.getModel().getDocument().createElement(this.getTag());
        if (this._cssProperty != null && this._cssPropertyValue != null) {
            element.setAttribute(this._cssProperty, this._cssPropertyValue);
        }
        return element;
    }

    public final String getCssProperty() {
        return this._cssProperty;
    }

    public final void setCssProperty(String property) {
        this._cssProperty = property;
    }

    public final String getCssPropertyValue() {
        return this._cssPropertyValue;
    }

    public final void setCssPropertyValue(String propertyValue) {
        this._cssPropertyValue = propertyValue;
    }

    public final String getTag() {
        if (this._tag != null) {
            return this._tag;
        }
        return this._applyingNode.getNodeName();
    }

    public final void setTag(String _tag) {
        this._tag = _tag;
    }
}

