/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Set;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToManyRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ICreateUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class CreateManyToManyUniDirRelationFeature
extends CreateManyToManyRelationFeature
implements ICreateUniDirRelationFeature {
    public CreateManyToManyUniDirRelationFeature(IJPAEditorFeatureProvider fp) {
        super(fp, JPAEditorMessages.CreateManyToManyUniDirRelationFeature_manyToManyUniDirFeatureName, JPAEditorMessages.CreateManyToManyUniDirRelationFeature_manyToManyUniDirFeatureDescription);
    }

    @Override
    public ManyToManyUniDirRelation createRelation(IJPAEditorFeatureProvider fp, PictogramElement source, PictogramElement target, PersistentType embeddingEntity) {
        String attributeName;
        PersistentType owner = (PersistentType)this.getBusinessObjectForPictogramElement(source);
        PersistentType inverse = (PersistentType)this.getBusinessObjectForPictogramElement(target);
        String nameWithNonCapitalLetter = attributeName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(inverse));
        if (JpaArtifactFactory.instance().isMethodAnnotated(owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(attributeName);
        }
        String attributeText = JPAEditorUtil.produceUniqueAttributeName(owner, nameWithNonCapitalLetter);
        ManyToManyUniDirRelation relation = new ManyToManyUniDirRelation(fp, owner, inverse, attributeText, true);
        return relation;
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.jpadiagrameditor.ui.many_to_many_1_dir_relation";
    }

    @Override
    protected boolean isRelationshipPossible() {
        if (JpaArtifactFactory.instance().isEmbeddable(this.owner)) {
            Set<HasReferanceRelation> refs = JpaArtifactFactory.instance().findAllHasReferenceRelsByEmbeddableWithEntity(this.owner, this.getFeatureProvider());
            if (refs.isEmpty()) {
                return false;
            }
            for (HasReferanceRelation ref : refs) {
                AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ref.getEmbeddedAnnotatedAttribute());
                if (!(attributeMapping instanceof ElementCollectionMapping2_0) && !(attributeMapping instanceof EmbeddedIdMapping)) continue;
                return false;
            }
        }
        return true;
    }
}

