/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping.types;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.scoping.types.AbstractKnownTypesScope;
import org.eclipse.emf.ecore.xcore.scoping.types.AbstractXcoreScope;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Strings;

public class KnownTypesScope
extends AbstractKnownTypesScope {
    private final List<? extends JvmType> types;

    public KnownTypesScope(List<? extends JvmType> types, AbstractXcoreScope parent) {
        super(parent);
        this.types = types;
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        int i = 0;
        int size = this.types.size();
        while (i < size) {
            JvmType knownType = this.types.get(i);
            if (EcoreUtil.isAncestor((EObject)knownType, (EObject)type)) {
                this.doGetDescriptions(type, knownType, i, result);
            }
            ++i;
        }
        super.doGetElements(type, result);
    }

    @Override
    protected IEObjectDescription doGetSingleElement(QualifiedName name, String firstSegment, int dollarIndex) {
        int index = -1;
        JvmType result = null;
        int i = 0;
        int size = this.types.size();
        while (i < size) {
            JvmType type = this.types.get(i);
            JvmType exactMatch = this.getExactMatch(type, index, name);
            if (exactMatch != null) {
                return EObjectDescription.create((QualifiedName)name, (EObject)exactMatch);
            }
            if (this.isMatch(i, type, firstSegment, name)) {
                JvmType resolved = this.getUnambiguousResult(result, index, type, i, name);
                if (resolved == null) {
                    return null;
                }
                if (resolved != result) {
                    result = resolved;
                    index = i;
                }
            }
            ++i;
        }
        return this.toDescription(name, result, dollarIndex, index);
    }

    @Override
    protected IEObjectDescription toDescription(QualifiedName name, JvmType result, int dollarIndex, int index) {
        if (result != null) {
            JvmType actualResult;
            JvmType jvmType = actualResult = dollarIndex > 0 || name.getSegmentCount() > 0 ? this.findNestedType(result, index, name) : result;
            if (actualResult != null) {
                return EObjectDescription.create((QualifiedName)name, (EObject)actualResult);
            }
        }
        return null;
    }

    protected JvmType getExactMatch(JvmType type, int index, QualifiedName qualifiedName) {
        String typeIdentifier = type.getIdentifier();
        String name = qualifiedName.toString();
        if (name.startsWith(typeIdentifier)) {
            int typeIdentifierLength = typeIdentifier.length();
            if (typeIdentifierLength == name.length()) {
                return type;
            }
            char delimiter = name.charAt(typeIdentifierLength);
            if (delimiter != '$' && delimiter != '.') {
                return null;
            }
            String nestedType = name.substring(typeIdentifierLength - type.getSimpleName().length() + 1);
            JvmType result = this.findNestedType(type, index, QualifiedName.create((List)Strings.split((String)nestedType, (char)'.')));
            return result;
        }
        return null;
    }

    protected boolean isMatch(int index, JvmType type, String simpleName, QualifiedName relativeName) {
        return simpleName.equals(type.getSimpleName());
    }

    @Override
    protected void doGetDescriptions(JvmType type, JvmType knownType, int index, List<IEObjectDescription> result) {
        if (type == knownType) {
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)type.getSimpleName()), (EObject)type));
        } else if (type.eContainer() == knownType) {
            String knownTypeSimpleName = knownType.getSimpleName();
            String typeSimpleName = type.getSimpleName();
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String[])new String[]{knownTypeSimpleName, typeSimpleName}), (EObject)type));
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)(String.valueOf(knownTypeSimpleName) + '$' + typeSimpleName)), (EObject)type));
        } else {
            String knownTypeName = knownType.getQualifiedName();
            String withDollar = type.getQualifiedName('$');
            String withDot = type.getQualifiedName('.');
            int knowTypeNameLength = knownTypeName.length();
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((List)Strings.split((String)withDot.substring(knowTypeNameLength), (char)'.')), (EObject)type));
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)withDollar.substring(knowTypeNameLength)), (EObject)type));
        }
    }
}

