/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IDebugNewExecutableHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.Messages;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.RefreshableDebugCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.NewExecutableDialog;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.NewExecutableInfo;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.ui.progress.UIJob;

public class GdbDebugNewExecutableCommand
extends RefreshableDebugCommand
implements IDebugNewExecutableHandler {
    private final ILaunch fLaunch;
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbDebugNewExecutableCommand(DsfSession session, ILaunch launch) {
        this.fLaunch = launch;
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public boolean canDebugNewExecutable() {
        Query<Boolean> canDebugQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IProcesses procService = (IProcesses)GdbDebugNewExecutableCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbDebugNewExecutableCommand.this.fTracker.getService(ICommandControlService.class);
                if (procService == null || commandControl == null) {
                    rm.setData((Object)false);
                    rm.done();
                    return;
                }
                procService.isDebugNewProcessSupported((IDMContext)commandControl.getContext(), rm);
            }
        };
        try {
            this.fExecutor.execute((Runnable)canDebugQuery);
            return (Boolean)canDebugQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return false;
    }

    public void debugNewExecutable(final RequestMonitor rm) {
        IGDBBackend backend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        final IProcesses procService = (IProcesses)this.fTracker.getService(IProcesses.class);
        final ICommandControlService commandControl = (ICommandControlService)this.fTracker.getService(ICommandControlService.class);
        if (backend == null || procService == null || commandControl == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", "Service is not available"));
            rm.done();
            return;
        }
        PromptJob job = new PromptJob(backend.getSessionType(), new DataRequestMonitor<NewExecutableInfo>((Executor)this.fExecutor, rm){

            protected void handleCancel() {
                rm.cancel();
                rm.done();
            }

            protected void handleSuccess() {
                try {
                    Map attributes = GdbDebugNewExecutableCommand.this.getLaunchConfiguration().getAttributes();
                    attributes.putAll(((NewExecutableInfo)this.getData()).getAttributes());
                    procService.debugNewProcess((IDMContext)commandControl.getContext(), ((NewExecutableInfo)this.getData()).getHostPath(), attributes, (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
                }
                catch (CoreException e) {
                    rm.setStatus(e.getStatus());
                    rm.done();
                }
            }
        });
        job.schedule();
    }

    /*
     * Exception decompiling
     */
    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        return this.canDebugNewExecutable();
    }

    protected Object getTarget(Object element) {
        if (element instanceof GdbLaunch || element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    private ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunch.getLaunchConfiguration();
    }

    private class PromptJob
    extends UIJob {
        private DataRequestMonitor<NewExecutableInfo> fRequestMonitor;
        private final SessionType fSessionType;

        private PromptJob(SessionType sessionType, DataRequestMonitor<NewExecutableInfo> rm) {
            super(Messages.GdbDebugNewExecutableCommand_New_Executable_Prompt_Job);
            this.fSessionType = sessionType;
            this.fRequestMonitor = rm;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            final NewExecutableInfo info = new NewExecutableInfo(this.fSessionType);
            NewExecutableDialog dialog = new NewExecutableDialog(GdbUIPlugin.getShell(), info);
            final boolean canceled = dialog.open() == 1;
            GdbDebugNewExecutableCommand.this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (canceled) {
                        PromptJob.this.fRequestMonitor.cancel();
                    } else {
                        PromptJob.this.fRequestMonitor.setData((Object)info);
                    }
                    PromptJob.this.fRequestMonitor.done();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

