/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.test.internal.performance.InternalPerformanceMeter;
import org.eclipse.test.internal.performance.PerformanceMonitor;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.data.Scalar;

public class OSPerformanceMeter
extends InternalPerformanceMeter {
    private PerformanceMonitor fPerformanceMonitor;
    private long fStartTime;
    private List<DataPoint> fDataPoints = new ArrayList<DataPoint>();

    public OSPerformanceMeter(String scenarioId) {
        super(scenarioId);
        this.fPerformanceMonitor = PerformanceMonitor.getPerformanceMonitor();
        this.fStartTime = System.currentTimeMillis();
    }

    @Override
    public void dispose() {
        this.fPerformanceMonitor = null;
        this.fDataPoints = null;
        super.dispose();
    }

    @Override
    public void start() {
        this.snapshot(0);
    }

    @Override
    public void stop() {
        this.snapshot(1);
    }

    @Override
    public Sample getSample() {
        if (this.fDataPoints != null) {
            HashMap<String, String> runProperties = new HashMap<String, String>();
            this.collectRunInfo(runProperties);
            return new Sample(this.getScenarioName(), this.fStartTime, runProperties, this.fDataPoints.toArray(new DataPoint[this.fDataPoints.size()]));
        }
        return null;
    }

    private void snapshot(int step) {
        HashMap<Dim, Scalar> map = new HashMap<Dim, Scalar>();
        this.fPerformanceMonitor.collectOperatingSystemCounters(map);
        this.fDataPoints.add(new DataPoint(step, map));
    }

    private void collectRunInfo(HashMap runProperties) {
        this.fPerformanceMonitor.collectGlobalPerformanceInfo(runProperties);
    }
}

