/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class DirectoryNameValidator
extends Validator {
    public static final String INFO_MISSING_DIR_NAME = "DirectoryNameValidator_Information_MissingName";
    public static final String ERROR_IS_FILE = "DirectoryNameValidator_Error_IsFile";
    public static final String ERROR_MUST_EXIST = "DirectoryNameValidator_Error_MustExist";
    public static final String ERROR_READ_ONLY = "DirectoryNameValidator_Error_ReadOnly";
    public static final String ERROR_NO_ACCESS = "DirectoryNameValidator_Error_NoAccess";
    public static final String ERROR_IS_RELATIV = "DirectoryNameValidator_Error_IsRelativ";
    public static final String ERROR_IS_ABSOLUT = "DirectoryNameValidator_Error_IsAbsolut";
    public static final int ATTR_MUST_EXIST = 2;
    public static final int ATTR_CAN_READ = 4;
    public static final int ATTR_CAN_WRITE = 8;
    public static final int ATTR_ABSOLUT = 16;
    public static final int ATTR_RELATIV = 32;
    public static final int ATTR_REMOTE_PATH = 64;
    private boolean isDir;
    private boolean exists;
    private boolean canRead;
    private boolean canWrite;
    private boolean absolute;

    public DirectoryNameValidator(int attributes) {
        super(attributes);
    }

    @Override
    protected void init() {
        super.init();
        this.isDir = false;
        this.exists = false;
        this.canRead = false;
        this.canWrite = false;
        this.absolute = false;
    }

    @Override
    public boolean isValid(String newFile) {
        this.init();
        if (newFile == null || newFile.trim().length() == 0) {
            if (this.isAttribute(1)) {
                this.setMessage(this.getMessageText(INFO_MISSING_DIR_NAME), this.getMessageTextType(INFO_MISSING_DIR_NAME, 1));
                return false;
            }
            return true;
        }
        newFile = newFile.trim();
        Path path = new Path(newFile);
        File dir = path.toFile();
        this.absolute = this.isAttribute(64) ? path.isAbsolute() : dir.isAbsolute();
        this.exists = dir.exists();
        this.isDir = dir.isDirectory() || !this.exists;
        File parentDir = dir.getParentFile();
        while (parentDir != null && !parentDir.exists()) {
            parentDir = parentDir.getParentFile();
        }
        this.canRead = dir.canRead() || !this.exists && parentDir != null && parentDir.canWrite();
        boolean bl = this.canWrite = dir.canWrite() || !this.exists && parentDir != null && parentDir.canWrite();
        if (!this.isAttribute(64) && this.isAttribute(2) && !this.exists) {
            this.setMessage(this.getMessageText(ERROR_MUST_EXIST), this.getMessageTextType(ERROR_MUST_EXIST, 3));
        } else if (this.isAttribute(16) && !this.isAttribute(32) && !this.absolute) {
            this.setMessage(this.getMessageText(ERROR_IS_RELATIV), this.getMessageTextType(ERROR_IS_RELATIV, 3));
        } else if (this.isAttribute(32) && !this.isAttribute(16) && this.absolute) {
            this.setMessage(this.getMessageText(ERROR_IS_ABSOLUT), this.getMessageTextType(ERROR_IS_ABSOLUT, 3));
        } else if (this.exists && !this.isDir) {
            this.setMessage(this.getMessageText(ERROR_IS_FILE), this.getMessageTextType(ERROR_IS_FILE, 3));
        } else if (!this.isAttribute(64) && this.isAttribute(4) && !this.canRead) {
            this.setMessage(this.getMessageText(ERROR_NO_ACCESS), this.getMessageTextType(ERROR_NO_ACCESS, 3));
        } else if (!this.isAttribute(64) && this.isAttribute(8) && !this.canWrite) {
            this.setMessage(this.getMessageText(ERROR_READ_ONLY), this.getMessageTextType(ERROR_READ_ONLY, 3));
        }
        return this.getMessageType() != 3;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isRelative() {
        return !this.absolute;
    }
}

