/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.update.configurator.PlatformConfiguration;
import org.eclipse.pde.internal.core.update.configurator.SiteEntry;

public class PluginPathFinder {
    private static final String URL_PROPERTY = "org.eclipse.update.resolution_url";

    private static String getSitePath(String platformHome, File linkFile, boolean features) {
        String prefix = new Path(platformHome).removeLastSegments(1).toString();
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream fis = new FileInputStream(linkFile);){
                properties.load(fis);
                String path = properties.getProperty("path");
                if (path != null) {
                    if (!new Path(path).isAbsolute()) {
                        path = String.valueOf(prefix) + '/' + path;
                    }
                    path = String.valueOf(path) + "/eclipse/";
                    path = features ? String.valueOf(path) + "features" : String.valueOf(path) + "plugins";
                    if (new File(path).exists()) {
                        return path;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static File[] getSites(String platformHome, boolean features) {
        File[] linkFiles;
        HashSet<File> sites = new HashSet<File>();
        File file = new File(platformHome, features ? "features" : "plugins");
        if (!features && !file.exists()) {
            file = new File(platformHome);
        }
        if (file.exists()) {
            sites.add(file);
        }
        if ((linkFiles = new File(String.valueOf(platformHome) + '/' + "links").listFiles()) != null) {
            File[] fileArray = linkFiles;
            int n = linkFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File linkFile = fileArray[n2];
                String path = PluginPathFinder.getSitePath(platformHome, linkFile, features);
                if (path != null) {
                    sites.add(new File(path));
                }
                ++n2;
            }
        }
        if (sites.isEmpty() && (file = new File(platformHome)).exists()) {
            sites.add(file);
        }
        return sites.toArray(new File[sites.size()]);
    }

    public static URL[] getFeaturePaths(String platformHome) {
        File file = PluginPathFinder.getPlatformFile(platformHome);
        if (file != null) {
            URL[] uRLArray;
            String value = new Path(platformHome).toFile().toURL().toExternalForm();
            System.setProperty(URL_PROPERTY, value);
            try {
                PlatformConfiguration config = new PlatformConfiguration(file.toURL());
                uRLArray = PluginPathFinder.getConfiguredSitesPaths(platformHome, config);
            }
            catch (Throwable throwable) {
                try {
                    System.setProperty(URL_PROPERTY, "");
                    throw throwable;
                }
                catch (Exception e) {
                    PDECore.log(e);
                }
            }
            System.setProperty(URL_PROPERTY, "");
            return uRLArray;
        }
        return PluginPathFinder.scanLocations(PluginPathFinder.getSites(platformHome, true));
    }

    private static File getPlatformFile(String platformHome) {
        String location = System.getProperty("org.eclipse.pde.platform_location");
        File file = null;
        if (location != null) {
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                location = manager.performStringSubstitution(location);
                Path path = new Path(location);
                file = path.isAbsolute() ? path.toFile() : new File(platformHome, location);
                if (file.exists()) {
                    return file;
                }
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
        }
        return (file = new File(platformHome, "configuration/org.eclipse.update/platform.xml")).exists() ? file : null;
    }

    private static URL[] getConfiguredSitesPaths(String platformHome, PlatformConfiguration configuration) {
        URL[] installPlugins = PluginPathFinder.scanLocations(new File[]{new File(platformHome, "features")});
        URL[] extensionPlugins = PluginPathFinder.getExtensionPluginURLs(configuration);
        URL[] all = new URL[installPlugins.length + extensionPlugins.length];
        System.arraycopy(installPlugins, 0, all, 0, installPlugins.length);
        System.arraycopy(extensionPlugins, 0, all, installPlugins.length, extensionPlugins.length);
        return all;
    }

    private static URL[] getExtensionPluginURLs(PlatformConfiguration config) {
        SiteEntry[] sites;
        ArrayList<URL> extensionPlugins = new ArrayList<URL>();
        SiteEntry[] siteEntryArray = sites = config.getConfiguredSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry site = siteEntryArray[n2];
            URL url = site.getURL();
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                String[] entries;
                String[] stringArray = entries = site.getFeatures();
                int n3 = entries.length;
                int n4 = 0;
                while (n4 < n3) {
                    String entry = stringArray[n4];
                    try {
                        extensionPlugins.add(new File(url.getFile(), entry).toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++n4;
                }
            }
            ++n2;
        }
        return extensionPlugins.toArray(new URL[extensionPlugins.size()]);
    }

    public static URL[] scanLocations(File[] sites) {
        HashSet<URL> result = new HashSet<URL>();
        int i = 0;
        while (i < sites.length) {
            File[] children;
            if (sites[i].exists() && (children = sites[i].listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File element = fileArray[n2];
                    try {
                        result.add(element.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++n2;
                }
            }
            ++i;
        }
        return result.toArray(new URL[result.size()]);
    }
}

