/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.discoverer.internal.IModelReader;
import org.eclipse.modisco.java.discoverer.internal.io.library.LibraryReader;
import org.eclipse.modisco.java.emf.JavaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverJavaModelFromClassFile
extends AbstractModelDiscoverer<IClassFile> {
    public static final String ID = "org.eclipse.modisco.java.discoverer.class";

    public boolean isApplicableTo(IClassFile classFile) {
        return classFile.exists();
    }

    protected static JavaFactory getEFactory() {
        return JavaFactory.eINSTANCE;
    }

    protected static IModelReader getClassReader() {
        return new LibraryReader(DiscoverJavaModelFromClassFile.getEFactory());
    }

    protected void basicDiscoverElement(IClassFile classFile, IProgressMonitor monitor) throws DiscoveryException {
        IJavaProject javaProject = classFile.getJavaProject();
        if (javaProject == null) {
            return;
        }
        IProject project = javaProject.getProject();
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)project.getFullPath().append(classFile.getElementName()).toString().concat("_java.xmi"), (boolean)true));
        Model model = DiscoverJavaModelFromClassFile.getEFactory().createModel();
        this.createTargetModel().getContents().add((Object)model);
        IModelReader reader = DiscoverJavaModelFromClassFile.getClassReader();
        reader.readModel(classFile, model, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        reader.terminate(monitor);
    }
}

