/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.descriptors;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.DescriptorMessages;
import org.eclipse.jdt.internal.core.refactoring.descriptors.JavaRefactoringDescriptorUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameJavaElementDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private static final String ATTRIBUTE_MATCH_STRATEGY = "matchStrategy";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_RENAME_GETTER = "getter";
    private static final String ATTRIBUTE_RENAME_SETTER = "setter";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final int STRATEGY_EMBEDDED = 2;
    public static final int STRATEGY_EXACT = 1;
    public static final int STRATEGY_SUFFIX = 3;
    @Deprecated
    private static final String RENAME_RESOURCE = "org.eclipse.jdt.ui.rename.resource";
    private boolean fDelegate = false;
    private boolean fDeprecate = false;
    private boolean fHierarchical = false;
    private IJavaElement fJavaElement = null;
    private int fMatchStrategy = 1;
    private String fName = null;
    private String fPatterns = null;
    private boolean fQualified = false;
    private boolean fReferences = false;
    private boolean fRenameGetter = false;
    private boolean fRenameSetter = false;
    private boolean fSimilarDeclarations = false;
    private boolean fTextual = false;

    public RenameJavaElementDescriptor(String id) {
        super(id);
        Assert.isLegal((boolean)this.checkId(id), (String)"Refactoring id is not a rename refactoring id");
    }

    public RenameJavaElementDescriptor(String id, String project, String description, String comment, Map<String, String> arguments, int flags) {
        super(id, project, description, comment, arguments, flags);
        int type;
        Assert.isLegal((boolean)this.checkId(id), (String)"Refactoring id is not a rename refactoring id");
        this.fName = JavaRefactoringDescriptorUtil.getString(this.fArguments, "name");
        if ("org.eclipse.jdt.ui.rename.type.parameter".equals(this.getID())) {
            this.fJavaElement = JavaRefactoringDescriptorUtil.getJavaElement(this.fArguments, "input", this.getProject());
            String parameterName = JavaRefactoringDescriptorUtil.getString(this.fArguments, ATTRIBUTE_PARAMETER);
            if (this.fJavaElement instanceof IType) {
                this.fJavaElement = ((IType)this.fJavaElement).getTypeParameter(parameterName);
            }
            if (this.fJavaElement instanceof IMethod) {
                this.fJavaElement = ((IMethod)this.fJavaElement).getTypeParameter(parameterName);
            }
        } else {
            this.fJavaElement = JavaRefactoringDescriptorUtil.getJavaElement(this.fArguments, "input", this.getProject());
        }
        if ((type = this.fJavaElement.getElementType()) != 3) {
            this.fReferences = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, "references", this.fReferences);
        }
        if (type == 8) {
            this.fRenameGetter = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_RENAME_GETTER, this.fRenameGetter);
            this.fRenameSetter = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_RENAME_SETTER, this.fRenameSetter);
        }
        switch (type) {
            case 4: 
            case 7: 
            case 8: {
                this.fTextual = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_TEXTUAL_MATCHES, this.fTextual);
                break;
            }
        }
        switch (type) {
            case 8: 
            case 9: {
                this.fDeprecate = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_DEPRECATE, this.fDeprecate);
                this.fDelegate = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_DELEGATE, this.fDelegate);
                break;
            }
        }
        switch (type) {
            case 4: 
            case 7: {
                this.fQualified = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_QUALIFIED, this.fQualified);
                this.fPatterns = JavaRefactoringDescriptorUtil.getString(this.fArguments, ATTRIBUTE_PATTERNS, true);
                break;
            }
        }
        switch (type) {
            case 7: {
                this.fSimilarDeclarations = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_SIMILAR_DECLARATIONS, this.fSimilarDeclarations);
                this.fMatchStrategy = JavaRefactoringDescriptorUtil.getInt(this.fArguments, ATTRIBUTE_MATCH_STRATEGY, this.fMatchStrategy);
                break;
            }
        }
        switch (type) {
            case 4: {
                this.fHierarchical = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_HIERARCHICAL, this.fHierarchical);
                break;
            }
        }
    }

    private boolean checkId(String id) {
        Assert.isNotNull((Object)id);
        switch (id) {
            case "org.eclipse.jdt.ui.rename.compilationunit": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.enum.constant": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.field": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.java.project": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.local.variable": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.method": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.package": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.resource": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.source.folder": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.type": {
                return true;
            }
            case "org.eclipse.jdt.ui.rename.type.parameter": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        JavaRefactoringDescriptorUtil.setString(this.fArguments, "name", this.fName);
        if ("org.eclipse.jdt.ui.rename.type.parameter".equals(this.getID())) {
            ITypeParameter parameter = (ITypeParameter)this.fJavaElement;
            JavaRefactoringDescriptorUtil.setJavaElement(this.fArguments, "input", this.getProject(), (IJavaElement)parameter.getDeclaringMember());
            JavaRefactoringDescriptorUtil.setString(this.fArguments, ATTRIBUTE_PARAMETER, parameter.getElementName());
        } else {
            JavaRefactoringDescriptorUtil.setJavaElement(this.fArguments, "input", this.getProject(), this.fJavaElement);
        }
        int type = this.fJavaElement.getElementType();
        if (type != 3) {
            JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, "references", this.fReferences);
        }
        if (type == 8) {
            JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_RENAME_GETTER, this.fRenameGetter);
            JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_RENAME_SETTER, this.fRenameSetter);
        }
        switch (type) {
            case 4: 
            case 7: 
            case 8: {
                JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_TEXTUAL_MATCHES, this.fTextual);
                break;
            }
        }
        switch (type) {
            case 8: 
            case 9: {
                JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_DEPRECATE, this.fDeprecate);
                JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_DELEGATE, this.fDelegate);
                break;
            }
        }
        switch (type) {
            case 4: 
            case 7: {
                JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_QUALIFIED, this.fQualified);
                JavaRefactoringDescriptorUtil.setString(this.fArguments, ATTRIBUTE_PATTERNS, this.fPatterns);
                break;
            }
        }
        switch (type) {
            case 7: {
                JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_SIMILAR_DECLARATIONS, this.fSimilarDeclarations);
                JavaRefactoringDescriptorUtil.setInt(this.fArguments, ATTRIBUTE_MATCH_STRATEGY, this.fMatchStrategy);
                break;
            }
        }
        switch (type) {
            case 4: {
                JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_HIERARCHICAL, this.fHierarchical);
                break;
            }
        }
    }

    public void setDeprecateDelegate(boolean deprecate) {
        this.fDeprecate = deprecate;
    }

    public void setFileNamePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        Assert.isLegal((!"".equals(patterns) ? 1 : 0) != 0, (String)"Pattern must not be empty");
        this.fPatterns = patterns;
    }

    public void setJavaElement(IJavaElement element) {
        Assert.isNotNull((Object)element);
        this.fJavaElement = element;
    }

    public void setKeepOriginal(boolean delegate) {
        this.fDelegate = delegate;
    }

    public void setMatchStrategy(int strategy) {
        Assert.isLegal((strategy == 1 || strategy == 2 || strategy == 3 ? 1 : 0) != 0, (String)"Wrong match strategy argument");
        this.fMatchStrategy = strategy;
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = name;
    }

    @Override
    public void setProject(String project) {
        super.setProject(project);
    }

    public void setRenameGetters(boolean rename) {
        this.fRenameGetter = rename;
    }

    public void setRenameSetters(boolean rename) {
        this.fRenameSetter = rename;
    }

    public void setUpdateHierarchy(boolean update) {
        this.fHierarchical = update;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fQualified = update;
    }

    public void setUpdateReferences(boolean update) {
        this.fReferences = update;
    }

    public void setUpdateSimilarDeclarations(boolean update) {
        this.fSimilarDeclarations = update;
    }

    public void setUpdateTextualOccurrences(boolean update) {
        this.fTextual = update;
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fName == null || "".equals(this.fName)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fJavaElement == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_no_java_element));
        } else {
            int type = this.fJavaElement.getElementType();
            if (type == 2 && this.getProject() != null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_project_constraint));
            }
            if (type == 3 && this.fReferences) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_reference_constraint));
            }
            if (this.fTextual) {
                switch (type) {
                    case 4: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_textual_constraint));
                    }
                }
            }
            if (this.fDeprecate) {
                switch (type) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_deprecation_constraint));
                    }
                }
            }
            if (this.fDelegate) {
                switch (type) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_delegate_constraint));
                    }
                }
            }
            if ((this.fRenameGetter || this.fRenameSetter) && type != 8) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_accessor_constraint));
            }
            if (this.fQualified) {
                switch (type) {
                    case 4: 
                    case 7: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_qualified_constraint));
                    }
                }
            }
            if (this.fSimilarDeclarations) {
                switch (type) {
                    case 7: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_similar_constraint));
                    }
                }
            }
            if (this.fHierarchical) {
                switch (type) {
                    case 4: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_hierarchical_constraint));
                    }
                }
            }
        }
        return status;
    }
}

