/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.context.ExtendedPropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.DomainPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.context.impl.EObjectPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesContextService;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PropertiesEditionContentProvider
implements IStructuredContentProvider {
    private AdapterFactory adapterFactory;
    private IPropertiesEditionComponent propertiesEditionComponent;
    private String mode;
    private EditingDomain editingDomain;
    private List<IPropertiesEditionListener> propertiesEditionListeners;

    public PropertiesEditionContentProvider(AdapterFactory adapterFactory, String mode) throws InstantiationException {
        if ("Live".equals(mode)) {
            throw new InstantiationException(EEFRuntimeUIMessages.PropertiesEditionContentProvider_editingDomain_not_defined);
        }
        this.adapterFactory = adapterFactory;
        this.mode = mode;
        this.propertiesEditionListeners = new ArrayList<IPropertiesEditionListener>();
    }

    public PropertiesEditionContentProvider(AdapterFactory adapterFactory, String mode, EditingDomain editingDomain) {
        this.adapterFactory = adapterFactory;
        this.mode = mode;
        this.editingDomain = editingDomain;
        this.propertiesEditionListeners = new ArrayList<IPropertiesEditionListener>();
    }

    public IPropertiesEditionComponent getPropertiesEditingComponent() {
        return this.propertiesEditionComponent;
    }

    public void dispose() {
        if (this.propertiesEditionComponent != null) {
            PropertiesContextService.getInstance().pop();
            this.propertiesEditionComponent.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.propertiesEditionComponent != null) {
            PropertiesContextService.getInstance().pop();
            this.propertiesEditionComponent.dispose();
            this.propertiesEditionComponent = null;
        }
        EObject eObject = null;
        ExtendedPropertiesEditingContext context = null;
        if (newInput instanceof EObject) {
            eObject = (EObject)newInput;
            if (this.mode == "Live") {
                context = new DomainPropertiesEditionContext(null, null, this.editingDomain, this.adapterFactory, eObject);
            } else if (this.mode == "Batch") {
                context = new EObjectPropertiesEditionContext(null, null, eObject, this.adapterFactory);
            }
        } else if (newInput instanceof EObjectPropertiesEditionContext) {
            context = (ExtendedPropertiesEditingContext)newInput;
            eObject = context.getEObject();
        }
        if (eObject != null) {
            this.propertiesEditionComponent = context.createPropertiesEditingComponent(this.mode);
            if (this.propertiesEditionComponent != null) {
                this.updateListeners();
            }
        }
        PropertiesContextService.getInstance().push(eObject, this.propertiesEditionComponent);
    }

    public void addPropertiesListener(IPropertiesEditionListener listener) {
        this.propertiesEditionListeners.add(listener);
        if (this.propertiesEditionComponent != null) {
            this.propertiesEditionComponent.addListener(listener);
        }
    }

    public void removePropertiesListener(IPropertiesEditionListener listener) {
        this.propertiesEditionListeners.add(listener);
        if (this.propertiesEditionComponent != null) {
            this.propertiesEditionComponent.removeListener(listener);
        }
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        if (this.propertiesEditionComponent != null) {
            return this.propertiesEditionComponent.validateValue(event);
        }
        return null;
    }

    public String[] partsList() {
        if (this.propertiesEditionComponent != null) {
            return this.propertiesEditionComponent.partsList();
        }
        return new String[0];
    }

    public IPropertiesEditionPart getPropertiesEditionPart(int kind, String key) {
        if (this.propertiesEditionComponent != null) {
            return this.propertiesEditionComponent.getPropertiesEditionPart(kind, key);
        }
        return null;
    }

    public Object translatePart(String key) {
        if (this.propertiesEditionComponent != null) {
            return this.propertiesEditionComponent.translatePart(key);
        }
        return null;
    }

    public void initPart(Object key, int kind, EObject element) {
        if (this.propertiesEditionComponent != null) {
            this.propertiesEditionComponent.initPart(key, kind, element);
        }
    }

    public void initPart(Object key, int kind, EObject element, ResourceSet allResources) {
        if (this.propertiesEditionComponent != null) {
            this.propertiesEditionComponent.initPart(key, kind, element, allResources);
        }
    }

    public Object[] getElements(Object inputElement) {
        return new Object[]{inputElement};
    }

    protected void updateListeners() {
        for (IPropertiesEditionListener listener : this.propertiesEditionListeners) {
            this.propertiesEditionComponent.addListener(listener);
        }
    }
}

