/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.spi.ui.TransferUIProvider;
import org.eclipse.emf.cdo.transfer.ui.TransferDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.dnd.DNDDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;

public class TransferDropAdapter
extends DNDDropAdapter<Object> {
    private TransferUIProvider[] uiProviders = this.getUIProviders();

    public TransferDropAdapter(StructuredViewer viewer) {
        super(viewer);
        ArrayList<Transfer> transfers = new ArrayList<Transfer>();
        int i = 0;
        while (i < this.uiProviders.length) {
            TransferUIProvider uiProvider = this.uiProviders[i];
            uiProvider.addSupportedTransfers(transfers);
            ++i;
        }
        this.setTransfers(transfers.toArray(new Transfer[transfers.size()]));
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected TransferUIProvider[] getUIProviders() {
        return TransferUIProvider.Factory.getAll(this.getContainer());
    }

    protected boolean validateTarget(Object target, int operation) {
        CDOTransferElement targetElement = this.getTargetElement(target);
        if (targetElement != null && targetElement.isDirectory()) {
            this.overrideOperation(1);
            return true;
        }
        return false;
    }

    protected boolean performDrop(Object data, Object target) {
        if (data == null) {
            return false;
        }
        List<CDOTransferElement> sourceElements = this.getSourceElements(data);
        if (sourceElements == null || sourceElements.isEmpty()) {
            return false;
        }
        CDOTransferElement targetElement = this.getTargetElement(target);
        if (targetElement == null || !targetElement.isDirectory()) {
            return false;
        }
        Shell shell = this.getViewer().getControl().getShell();
        return TransferDialog.open(shell, sourceElements, targetElement);
    }

    protected List<CDOTransferElement> getSourceElements(Object data) {
        int i = 0;
        while (i < this.uiProviders.length) {
            TransferUIProvider uiProvider = this.uiProviders[i];
            List<CDOTransferElement> elements = uiProvider.convertTransferData(data);
            if (elements != null) {
                return elements;
            }
            ++i;
        }
        return null;
    }

    protected CDOTransferElement getTargetElement(Object target) {
        int i = 0;
        while (i < this.uiProviders.length) {
            TransferUIProvider uiProvider = this.uiProviders[i];
            CDOTransferElement element = uiProvider.convertTransferTarget(target);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static TransferDropAdapter support(StructuredViewer viewer) {
        TransferDropAdapter dropAdapter = new TransferDropAdapter(viewer);
        Transfer[] transfers = dropAdapter.getTransfers();
        viewer.addDropSupport(19, transfers, (DropTargetListener)dropAdapter);
        return dropAdapter;
    }
}

