/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.bpel.model.ExtensionActivity;
import org.eclipse.bpel.model.util.ReconciliationHelper;
import org.eclipse.wst.wsdl.WSDLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ElementPlacer {
    private static HashMap<String, List<String>> mapper = new HashMap();
    private static final String ACTIVITY = "activity";

    static {
        String[] processElements = new String[]{"extensions", "import", "partnerLinks", "messageExchanges", "variables", "correlationSets", "faultHandlers", "eventHandlers", ACTIVITY};
        mapper.put("process", Arrays.asList(processElements));
        String[] faultHandlersElements = new String[]{"catch", "catchAll"};
        mapper.put("faultHandlers", Arrays.asList(faultHandlersElements));
        String[] eventHandlersElements = new String[]{"onEvent", "onAlarm"};
        mapper.put("eventHandlers", Arrays.asList(eventHandlersElements));
        String[] invokeElements = new String[]{"correlations", "catch", "catchAll", "compensationHandler", "toParts", "fromParts"};
        mapper.put("invoke", Arrays.asList(invokeElements));
        String[] whileElements = new String[]{"condition", ACTIVITY};
        mapper.put("while", Arrays.asList(whileElements));
        String[] forEachElements = new String[]{"startCounterValue", "finalCounterValue", "completionCondition", ACTIVITY};
        mapper.put("forEach", Arrays.asList(forEachElements));
        String[] repeatElements = new String[]{ACTIVITY, "condition"};
        mapper.put("repeatUntil", Arrays.asList(repeatElements));
        String[] ifElements = new String[]{"condition", ACTIVITY, "elseif", "else"};
        mapper.put("if", Arrays.asList(ifElements));
        String[] elseIfElements = new String[]{"condition", ACTIVITY};
        mapper.put("elseif", Arrays.asList(elseIfElements));
    }

    public static void placeChild(WSDLElement parent, Node child) {
        String nodeName;
        String nodeType;
        List<String> nodeTypeList;
        Element parentElement = parent.getElement();
        if (parent instanceof ExtensionActivity) {
            parentElement = ReconciliationHelper.getExtensionActivityChildElement(parentElement);
        }
        if ((nodeTypeList = mapper.get(parentElement.getLocalName())) != null && (nodeType = ElementPlacer.findType(nodeName = child.getLocalName(), nodeTypeList)) != null) {
            Node beforeElement = parentElement.getFirstChild();
            while (!(beforeElement == null || ElementPlacer.isPreviousType(nodeType, ElementPlacer.findType(beforeElement.getLocalName(), nodeTypeList), nodeTypeList) && beforeElement.getNodeType() == 1)) {
                beforeElement = beforeElement.getNextSibling();
            }
            while (beforeElement != null && (ElementPlacer.isType(beforeElement.getLocalName(), nodeType) || beforeElement.getNodeType() != 1)) {
                beforeElement = beforeElement.getNextSibling();
            }
            ElementPlacer.niceInsertBefore(parent, child, beforeElement);
            return;
        }
        ElementPlacer.niceAppend(parent, child);
    }

    private static String findType(String nodeName, List<String> nodeTypeList) {
        for (String nodeType : nodeTypeList) {
            if (!ElementPlacer.isType(nodeName, nodeType)) continue;
            return nodeType;
        }
        return null;
    }

    private static boolean isPreviousType(String typeName1, String typeName2, List<String> nodeTypeList) {
        int type2Index;
        int type1Index = nodeTypeList.indexOf(typeName1);
        return type1Index < (type2Index = nodeTypeList.indexOf(typeName2)) || type2Index < 0 && type1Index >= 0;
    }

    private static boolean isType(String nodeName, String typeName) {
        return ACTIVITY.equals(typeName) ? ElementPlacer.isActivity(nodeName) : typeName.equals(nodeName);
    }

    private static boolean isActivity(String nodeName) {
        return "assign".equals(nodeName) || "compensate".equals(nodeName) || "compensateScope".equals(nodeName) || "empty".equals(nodeName) || "exit".equals(nodeName) || "extensionActivity".equals(nodeName) || "flow".equals(nodeName) || "forEach".equals(nodeName) || "if".equals(nodeName) || "invoke".equals(nodeName) || "pick".equals(nodeName) || "receive".equals(nodeName) || "repeatUntil".equals(nodeName) || "reply".equals(nodeName) || "rethrow".equals(nodeName) || "scope".equals(nodeName) || "sequence".equals(nodeName) || "throw".equals(nodeName) || "validate".equals(nodeName) || "wait".equals(nodeName) || "while".equals(nodeName) || "opaqueActivity".equals(nodeName);
    }

    /*
     * Unable to fully structure code
     */
    public static void niceInsertBefore(WSDLElement parent, Node newChild, Node referenceChild) {
        was = ReconciliationHelper.isUpdatingDom(parent);
        parentElement = parent.getElement();
        if (parent instanceof ExtensionActivity) {
            parentElement = ReconciliationHelper.getExtensionActivityChildElement(parentElement);
        }
        ReconciliationHelper.setUpdatingDom(parent, true);
        v0 = child = referenceChild == null ? parentElement.getLastChild() : referenceChild.getPreviousSibling();
        if (child != null) ** GOTO lbl76
        indent = new StringBuffer();
        ancestor = parentElement.getParentNode();
        while (ancestor != null && ancestor.getNodeType() != 9) {
            indent.append("    ");
            ancestor = ancestor.getParentNode();
        }
        text = parentElement.getOwnerDocument().createTextNode("\n" + indent + "    ");
        parentElement.insertBefore(text, referenceChild);
        text = parentElement.getOwnerDocument().createTextNode("\n" + indent);
        referenceChild = parentElement.insertBefore(text, referenceChild);
        parentElement.insertBefore(newChild, referenceChild);
        return;
        while ((nodeType = child.getNodeType()) != 1) {
            if (nodeType != 3) {
                child = child.getPreviousSibling();
            } else {
                text = (Text)child;
                data = text.getData();
                index = data.lastIndexOf(10);
                if (index == -1) {
                    child = child.getPreviousSibling();
                } else {
                    indent = new StringBuffer();
                    ancestor = parentElement.getParentNode();
                    while (ancestor != null && ancestor.getNodeType() != 9) {
                        indent.append("    ");
                        ancestor = ancestor.getParentNode();
                    }
                    if (index + 1 < data.length() && data.charAt(index + 1) == '\r') {
                        ++index;
                    }
                    text.replaceData(index + 1, data.length() - index - 1, indent + "    ");
                    childIndent = new StringBuffer(indent);
                    nextNewChild = newChild;
                    innerChild = newChild.getFirstChild();
                    while (innerChild != null) {
                        nextInnerChild = innerChild;
                        while (nextInnerChild != null) {
                            textNodeIsWhitespaceOnly = false;
                            if (nextInnerChild instanceof Text) {
                                content = ((Text)nextInnerChild).getData();
                                v1 = textNodeIsWhitespaceOnly = content == null || content.trim().isEmpty() != false;
                            }
                            if (textNodeIsWhitespaceOnly) {
                                nextNewChild.removeChild(nextInnerChild);
                            } else {
                                nextNewChild.insertBefore(nextNewChild.getOwnerDocument().createTextNode("\n" + childIndent + "        "), nextInnerChild);
                            }
                            nextInnerChild = nextInnerChild.getNextSibling();
                        }
                        nextNewChild.appendChild(nextNewChild.getOwnerDocument().createTextNode("\n" + childIndent + "    "));
                        childIndent.append("    ");
                        nextNewChild = innerChild;
                        innerChild = innerChild.getFirstChild();
                    }
                    if (referenceChild != null) {
                        indent.append("    ");
                    }
                    text = parentElement.getOwnerDocument().createTextNode("\n" + indent);
                    parentElement.insertBefore(text, referenceChild);
                    referenceChild = text;
                    break;
                }
            }
lbl76:
            // 3 sources

            if (child != null) continue;
        }
        parentElement.insertBefore(newChild, referenceChild);
        ReconciliationHelper.setUpdatingDom(parent, was);
    }

    public static void niceAppend(WSDLElement parent, Node child) {
        ElementPlacer.niceInsertBefore(parent, child, null);
    }

    public static void niceRemoveChild(WSDLElement parent, Node child) {
        Text text;
        String data;
        int index;
        boolean was = ReconciliationHelper.isUpdatingDom(parent);
        ReconciliationHelper.setUpdatingDom(parent, true);
        Element parseElement = parent.getElement();
        if (parent instanceof ExtensionActivity) {
            parseElement = ReconciliationHelper.getExtensionActivityChildElement(parseElement);
        }
        boolean done = false;
        Node previous = child.getPreviousSibling();
        if (previous != null && previous.getNodeType() == 3 && (index = (data = (text = (Text)previous).getData()).lastIndexOf(10)) != -1) {
            if (index - 1 > 0 && data.charAt(index - 1) == '\r') {
                text.deleteData(index - 1, data.length() - index + 1);
            } else {
                text.deleteData(index, data.length() - index);
            }
            done = true;
        }
        if (!done) {
            Node next = child.getNextSibling();
            while (next != null) {
                if (next.getNodeType() == 3) {
                    Text text2 = (Text)next;
                    String data2 = text2.getData();
                    int index2 = data2.indexOf(10);
                    if (index2 != -1) {
                        if (index2 + 1 < data2.length() && data2.charAt(index2 + 1) == '\r') {
                            text2.deleteData(0, index2 + 2);
                            break;
                        }
                        text2.deleteData(0, index2 + 1);
                        break;
                    }
                } else if (next.getNodeType() == 1) break;
                next = next.getNextSibling();
            }
        }
        parseElement.removeChild(child);
        ReconciliationHelper.setUpdatingDom(parent, was);
    }
}

