/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.service;

import java.util.regex.Matcher;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.logging.ControlCommandLogger;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences.ControlPreferences;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceConstants;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceMI;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandInput;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandResult;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;

@NonNullByDefault
public final class LTTngControlServiceFactory {
    private LTTngControlServiceFactory() {
    }

    public static ILttngControlService getLttngControlService(ICommandShell shell) throws ExecutionException {
        boolean machineInterfaceMode = true;
        ICommandInput command = shell.createCommand();
        command.add("lttng");
        command.add("--mi");
        command.add("xml");
        command.add("version");
        ICommandResult result = LTTngControlServiceFactory.executeCommand(shell, command);
        if (result.getResult() != 0) {
            machineInterfaceMode = false;
            command = shell.createCommand();
            command.add("lttng");
            command.add("version");
            result = LTTngControlServiceFactory.executeCommand(shell, command);
        }
        if (result.getResult() == 0 && !result.getOutput().isEmpty()) {
            if (machineInterfaceMode) {
                LTTngControlServiceMI service = new LTTngControlServiceMI(shell, LTTngControlServiceMI.parseVersion(result));
                return service;
            }
            for (String line : result.getOutput()) {
                Matcher versionMatcher = LTTngControlServiceConstants.VERSION_PATTERN.matcher(line = line.replace("-", "."));
                if (!versionMatcher.matches()) continue;
                String version = versionMatcher.group(1).trim();
                Matcher matcher = LTTngControlServiceConstants.VERSION_2_PATTERN.matcher(version);
                if (matcher.matches()) {
                    LTTngControlService service = new LTTngControlService(shell);
                    service.setVersion((String)NonNullUtils.checkNotNull((Object)version));
                    return service;
                }
                throw new ExecutionException(String.valueOf(Messages.TraceControl_UnsupportedVersionError) + ": " + version);
            }
        }
        throw new ExecutionException(Messages.TraceControl_GettingVersionError);
    }

    private static ICommandResult executeCommand(ICommandShell shell, ICommandInput command) throws ExecutionException {
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(command.toString());
        }
        ICommandResult result = null;
        try {
            result = shell.executeCommand(command, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_GettingVersionError) + ": " + (Object)((Object)e));
        }
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(result.toString());
        }
        return result;
    }
}

