/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.impl.editpart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.gef.api.EditPart;
import org.eclipse.reddeer.gef.comparator.ChainedComparator;
import org.eclipse.reddeer.gef.comparator.ChildrenComparator;
import org.eclipse.reddeer.gef.comparator.PositionComparator;
import org.eclipse.reddeer.gef.handler.EditPartHandler;
import org.eclipse.reddeer.gef.handler.ViewerHandler;
import org.eclipse.reddeer.gef.lookup.EditPartLookup;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.swt.widgets.Control;
import org.hamcrest.Matcher;

public abstract class AbstractEditPart
implements EditPart,
ReferencedComposite {
    protected GraphicalViewer viewer;
    protected org.eclipse.gef.EditPart editPart;

    public AbstractEditPart(org.eclipse.gef.EditPart editPart) {
        this.editPart = editPart;
    }

    public AbstractEditPart(Matcher<org.eclipse.gef.EditPart> matcher) {
        this(matcher, 0);
    }

    public AbstractEditPart(Matcher<org.eclipse.gef.EditPart> matcher, int index) {
        this(EditPartLookup.getInstance().findEditPart(matcher, index, new ChainedComparator<org.eclipse.gef.EditPart>(new ChildrenComparator(), new PositionComparator())));
    }

    @Override
    public void select() {
        EditPartHandler.getInstance().select(this.editPart);
    }

    @Override
    public void click() {
        Rectangle bounds = this.getFigure().getBounds();
        Rectangle rec = bounds.getCopy();
        this.getFigure().translateToAbsolute((Translatable)rec);
        int x = rec.x + rec.width / 2;
        int y = rec.y + rec.height / 2;
        ViewerHandler.getInstance().click(this.editPart.getViewer(), x, y);
    }

    @Override
    public void setLabel(String text) {
        EditPartHandler.getInstance().select(this.editPart);
        EditPartHandler.getInstance().directEdit(this.editPart);
        DefaultText inputText = new DefaultText((ReferencedComposite)this, 0, new Matcher[0]);
        inputText.setText(text);
        WidgetHandler.getInstance().notifyWidget(14, inputText.getSWTWidget());
    }

    public Control getControl() {
        return this.editPart.getViewer().getControl();
    }

    @Override
    public org.eclipse.gef.EditPart getGEFEditPart() {
        return this.editPart;
    }

    protected IFigure getFigure() {
        return EditPartHandler.getInstance().getFigure(this.editPart);
    }
}

