/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal.rulesengine;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.rulesengine.ISynchronizationRule;

public class DownloadRule
implements ISynchronizationRule {
    private int overwritePolicy = 0;
    private boolean asReadOnly = false;
    private boolean asExecutable = false;
    private boolean preserveTimeStamp = false;
    private String localDirectory = null;
    private List<String> remoteFileList = new ArrayList<String>();

    public DownloadRule() {
    }

    public DownloadRule(String data) {
        String s;
        String[] list = data.split("\n");
        if (list.length < 1) {
            this.throwError(String.valueOf(Messages.DownloadRule_0) + this.getClass().getName());
        }
        if (!(s = list[0]).equalsIgnoreCase("download")) {
            this.throwError(String.valueOf(Messages.DownloadRule_0) + this.getClass().getName());
        }
        int i = 1;
        while (i < list.length) {
            String s2 = list[i];
            int p = s2.indexOf(32);
            if (p == -1) {
                this.logError(String.valueOf(Messages.DownloadRule_1) + s2);
            } else {
                String key = s2.substring(0, p);
                String value = s2.substring(p + 1);
                this.parseEntry(key, value);
            }
            ++i;
        }
    }

    public DownloadRule(DownloadRule rule) {
        this.overwritePolicy = rule.overwritePolicy;
        this.asReadOnly = rule.asReadOnly;
        this.asExecutable = rule.asExecutable;
        this.preserveTimeStamp = rule.preserveTimeStamp;
        this.localDirectory = rule.localDirectory != null ? new String(rule.localDirectory) : null;
        this.remoteFileList = new ArrayList<String>(rule.remoteFileList);
    }

    private void throwError(String string) {
        throw new RuntimeException(string);
    }

    private void parseEntry(String key, String value) {
        if (key.equalsIgnoreCase("local-path")) {
            this.localDirectory = value;
        } else if (key.equalsIgnoreCase("overwrite-policy")) {
            if (value.equalsIgnoreCase("always")) {
                this.overwritePolicy = 2;
            } else if (value.equalsIgnoreCase("ask")) {
                this.overwritePolicy = 4;
            } else if (value.equalsIgnoreCase("newer")) {
                this.overwritePolicy = 3;
            } else if (value.equalsIgnoreCase("skip")) {
                this.overwritePolicy = 1;
            } else {
                this.logError(String.valueOf(Messages.DownloadRule_2) + value);
            }
        } else if (key.equalsIgnoreCase("flags")) {
            String[] flags = value.split(" ");
            int i = 0;
            while (i < flags.length) {
                String flag = flags[i];
                if (flag.equalsIgnoreCase("timestamp")) {
                    this.preserveTimeStamp = true;
                } else {
                    this.logError(String.valueOf(Messages.DownloadRule_3) + flag);
                }
                ++i;
            }
        } else if (key.equalsIgnoreCase("remote-path")) {
            this.remoteFileList.add(value);
        } else if (key.equalsIgnoreCase("permissions")) {
            String[] flags = value.split(" ");
            int i = 0;
            while (i < flags.length) {
                String flag = flags[i];
                if (flag.equalsIgnoreCase("executable")) {
                    this.asExecutable = true;
                } else if (flag.equalsIgnoreCase("readonly")) {
                    this.asReadOnly = true;
                } else {
                    this.logError(String.valueOf(Messages.DownloadRule_4) + flag);
                }
                ++i;
            }
        } else {
            this.logError(String.valueOf(Messages.DownloadRule_5) + key);
        }
    }

    private void logError(String string) {
    }

    public String toString() {
        String s;
        ArrayList<String> l = new ArrayList<String>();
        if (this.localDirectory != null) {
            l.add("local-path " + this.localDirectory.trim());
        }
        if (this.overwritePolicy == 2) {
            l.add("overwrite-policy always");
        } else if (this.overwritePolicy == 4) {
            l.add("overwrite-policy ask");
        } else if (this.overwritePolicy == 3) {
            l.add("overwrite-policy newer");
        } else if (this.overwritePolicy == 1) {
            l.add("overwrite-policy skip");
        }
        if (this.asExecutable || this.asReadOnly) {
            s = "permissions";
            if (this.asExecutable) {
                s = String.valueOf(s) + " executable";
            }
            if (this.asReadOnly) {
                s = String.valueOf(s) + " readonly";
            }
            l.add(s);
        }
        if (this.preserveTimeStamp) {
            s = "flags";
            if (this.preserveTimeStamp) {
                s = String.valueOf(s) + " timestamp";
            }
            l.add(s);
        }
        for (String remotePath : this.remoteFileList) {
            if (remotePath == null || remotePath.trim().length() == 0) continue;
            l.add("remote-path " + remotePath.trim());
        }
        String result = new String("download");
        for (String element : l) {
            result = String.valueOf(result) + "\n" + element;
        }
        return result;
    }

    public boolean isAsExecutable() {
        return this.asExecutable;
    }

    public void setAsExecutable(boolean asExecutable) {
        this.asExecutable = asExecutable;
    }

    public boolean isAsReadOnly() {
        return this.asReadOnly;
    }

    public void setAsReadOnly(boolean asReadOnly) {
        this.asReadOnly = asReadOnly;
    }

    public int getOverwritePolicy() {
        return this.overwritePolicy;
    }

    public void setOverwritePolicy(int overwritePolicy) {
        this.overwritePolicy = overwritePolicy;
    }

    public boolean isPreserveTimeStamp() {
        return this.preserveTimeStamp;
    }

    public void setPreserveTimeStamp(boolean preserveTimeStamp) {
        this.preserveTimeStamp = preserveTimeStamp;
    }

    public String getLocalDirectory() {
        if (this.localDirectory != null) {
            return this.localDirectory.trim();
        }
        return null;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory != null ? localDirectory.trim() : null;
    }

    public int getRemoteFileCount() {
        return this.remoteFileList.size();
    }

    public String[] getRemoteFilesAsStringArray() {
        String[] result = new String[this.remoteFileList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.remoteFileList.get(i);
            ++i;
        }
        return result;
    }

    public IPath[] getRemoteFilesAsPathArray() {
        IPath[] result = new IPath[this.remoteFileList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new Path(this.remoteFileList.get(i));
            ++i;
        }
        return result;
    }

    public File[] getRemoteFilesAsFileArray() {
        File[] result = new File[this.remoteFileList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new File(this.remoteFileList.get(i));
            ++i;
        }
        return result;
    }

    public Iterator<?> remoteIteratorAsString() {
        return new RemoteFileIteratorAsString();
    }

    public Iterator<?> remoteIteratorAsPath() {
        return new RemoteFileIteratorAsPath();
    }

    public void addRemoteFile(String string) {
        if (string != null) {
            this.remoteFileList.add(string);
        }
    }

    public void addRemoteFile(IPath path) {
        if (path != null) {
            this.remoteFileList.add(path.toOSString());
        }
    }

    public static void main(String[] args) {
        DownloadRule r = new DownloadRule();
        System.out.println(r);
        r.setAsExecutable(true);
        System.out.println(r);
        r.setAsReadOnly(true);
        System.out.println(r);
        r.setLocalDirectory("/tmp/a");
        System.out.println(r);
        r.setOverwritePolicy(4);
        System.out.println(r);
    }

    public void removeRemoteFile(String entry) {
        Iterator<String> iter = this.remoteFileList.iterator();
        while (iter.hasNext()) {
            String element = iter.next();
            if (!element.equals(entry)) continue;
            iter.remove();
        }
    }

    public void removeRemoteFile(IPath entry) {
        this.removeRemoteFile(entry.toOSString());
    }

    public void setRemoteFiles(String[] items) {
        this.clearRemoteFiles();
        int i = 0;
        while (i < items.length) {
            String string = items[i];
            if (string != null) {
                this.addRemoteFile(string.trim());
            }
            ++i;
        }
    }

    public void setRemoteFiles(IPath[] items) {
        this.clearRemoteFiles();
        int i = 0;
        while (i < items.length) {
            IPath path = items[i];
            if (path != null) {
                this.addRemoteFile(path);
            }
            ++i;
        }
    }

    public void clearRemoteFiles() {
        this.remoteFileList.clear();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isDownloadRule() {
        return true;
    }

    @Override
    public boolean isUploadRule() {
        return false;
    }

    @Override
    public void validate() throws CoreException {
    }

    public class RemoteFileIteratorAsPath
    extends RemoteFileIteratorAsString {
        @Override
        public Object next() {
            return new Path((String)this.iteratorref.next());
        }
    }

    public class RemoteFileIteratorAsString
    implements Iterator<Object> {
        Iterator<String> iteratorref;

        public RemoteFileIteratorAsString() {
            this.iteratorref = DownloadRule.this.remoteFileList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iteratorref.hasNext();
        }

        @Override
        public Object next() {
            return this.iteratorref.next();
        }

        @Override
        public void remove() {
            this.iteratorref.remove();
        }
    }
}

