/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.legacy.WagonManager;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.ExtensionReader;
import org.eclipse.m2e.core.internal.MvnProtocolHandlerService;
import org.eclipse.m2e.core.internal.URLConnectionCaches;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeManager;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.index.filter.ArtifactFilterManager;
import org.eclipse.m2e.core.internal.index.nexus.IndexesExtensionReader;
import org.eclipse.m2e.core.internal.index.nexus.IndexingTransferListener;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.internal.launch.MavenRuntimeManagerImpl;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MavenMarkerManager;
import org.eclipse.m2e.core.internal.preferences.MavenConfigurationImpl;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.internal.project.WorkspaceClassifierResolverManager;
import org.eclipse.m2e.core.internal.project.WorkspaceStateWriter;
import org.eclipse.m2e.core.internal.project.conversion.ProjectConversionManager;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryRefreshJob;
import org.eclipse.m2e.core.internal.repository.RepositoryRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.IWorkspaceClassifierResolverManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.conversion.IProjectConversionManager;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPluginActivator
extends Plugin {
    private final Logger log = LoggerFactory.getLogger(MavenPlugin.class);
    public static final String PREFS_ARCHETYPES = "archetypesInfo.xml";
    private static MavenPluginActivator plugin;
    private Collection<PlexusContainer> toDisposeContainers = new HashSet<PlexusContainer>();
    private MavenModelManager modelManager;
    private NexusIndexManager indexManager;
    private BundleContext bundleContext;
    private MavenProjectManager projectManager;
    private MavenRuntimeManagerImpl runtimeManager;
    private ProjectConfigurationManager configurationManager;
    private ProjectRegistryRefreshJob mavenBackgroundJob;
    private ArchetypeManager archetypeManager;
    private ProjectRegistryManager managerImpl;
    private IMavenMarkerManager mavenMarkerManager;
    private RepositoryRegistry repositoryRegistry;
    private ArtifactFilterManager artifactFilterManager;
    private String version = "0.0.0";
    private String qualifiedVersion = "0.0.0.qualifier";
    private IMavenConfiguration mavenConfiguration;
    private BundleListener bundleListener = event -> LifecycleMappingFactory.setBundleMetadataSources(null);
    private ISaveParticipant saveParticipant = new ISaveParticipant(){

        public void saving(ISaveContext context) {
            if (MavenPluginActivator.this.managerImpl != null) {
                MavenPluginActivator.this.managerImpl.writeWorkspaceState();
            }
        }

        public void rollback(ISaveContext context) {
        }

        public void prepareToSave(ISaveContext context) {
        }

        public void doneSaving(ISaveContext context) {
        }
    };
    private MavenImpl maven;
    private IProjectConversionManager projectConversionManager;
    private IWorkspaceClassifierResolverManager workspaceClassifierResolverManager;
    private ServiceRegistration<URLStreamHandlerService> protocolHandlerService;

    public MavenPluginActivator() {
        plugin = this;
        if (Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.m2e.core/debug/initialization"))) {
            System.err.println("### executing constructor org.eclipse.m2e.core");
            new Throwable().printStackTrace();
        }
    }

    public MavenImpl getMaven() {
        return this.maven;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.m2e.core/debug/initialization"))) {
            System.err.println("### executing start() org.eclipse.m2e.core");
            new Throwable().printStackTrace();
        }
        System.setProperty("maven.defaultProjectBuilder.disableGlobalModelCache", Boolean.toString(true));
        URLConnectionCaches.disable();
        this.bundleContext = context;
        try {
            this.qualifiedVersion = (String)this.getBundle().getHeaders().get("Bundle-Version");
            Version bundleVersion = Version.parseVersion((String)this.qualifiedVersion);
            this.version = String.valueOf(bundleVersion.getMajor()) + "." + bundleVersion.getMinor() + "." + bundleVersion.getMicro();
        }
        catch (IllegalArgumentException bundleVersion) {
            // empty catch block
        }
        this.mavenConfiguration = new MavenConfigurationImpl();
        File stateLocationDir = this.getStateLocation().toFile();
        this.mavenMarkerManager = new MavenMarkerManager(this.mavenConfiguration);
        boolean updateProjectsOnStartup = this.mavenConfiguration.isUpdateProjectsOnStartup();
        this.maven = new MavenImpl(this.mavenConfiguration);
        this.managerImpl = new ProjectRegistryManager(this.maven, stateLocationDir, !updateProjectsOnStartup, this.mavenMarkerManager);
        this.mavenBackgroundJob = new ProjectRegistryRefreshJob(this.managerImpl, this.mavenConfiguration);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.mavenBackgroundJob, 7);
        this.projectManager = new MavenProjectManager(this.managerImpl, this.mavenBackgroundJob, stateLocationDir);
        this.projectManager.addMavenProjectChangedListener(new WorkspaceStateWriter(this.projectManager));
        if (updateProjectsOnStartup || this.managerImpl.getProjects().length == 0) {
            this.projectManager.refresh(new MavenUpdateRequest(workspace.getRoot().getProjects(), this.mavenConfiguration.isOffline(), false));
        }
        this.modelManager = new MavenModelManager(this.maven, this.projectManager);
        this.runtimeManager = new MavenRuntimeManagerImpl();
        this.configurationManager = new ProjectConfigurationManager(this.maven, this.managerImpl, this.modelManager, this.mavenMarkerManager, this.mavenConfiguration);
        this.projectManager.addMavenProjectChangedListener(this.configurationManager);
        workspace.addResourceChangeListener((IResourceChangeListener)this.configurationManager, 4);
        this.repositoryRegistry = new RepositoryRegistry(this.maven, this.projectManager);
        this.maven.addSettingsChangeListener(this.repositoryRegistry);
        this.projectManager.addMavenProjectChangedListener(this.repositoryRegistry);
        this.artifactFilterManager = new ArtifactFilterManager();
        this.repositoryRegistry.updateRegistry();
        this.projectConversionManager = new ProjectConversionManager();
        this.workspaceClassifierResolverManager = new WorkspaceClassifierResolverManager();
        ResourcesPlugin.getWorkspace().addSaveParticipant("org.eclipse.m2e.core", this.saveParticipant);
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"mvn"});
        this.protocolHandlerService = context.registerService(URLStreamHandlerService.class, (Object)new MvnProtocolHandlerService(), properties);
    }

    private DefaultPlexusContainer newPlexusContainer(ClassLoader cl) throws PlexusContainerException {
        AbstractModule logginModule = new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)LoggerFactory.getILoggerFactory());
            }
        };
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", cl)).setClassPathScanning("index").setAutoWiring(true).setName("plexus");
        return new DefaultPlexusContainer(cc, new Module[]{logginModule});
    }

    private static ArchetypeManager newArchetypeManager(PlexusContainer container, File stateLocationDir) {
        ArchetypeManager archetypeManager = new ArchetypeManager(container, new File(stateLocationDir, PREFS_ARCHETYPES));
        archetypeManager.addArchetypeCatalogFactory(new ArchetypeCatalogFactory.NexusIndexerCatalogFactory());
        archetypeManager.addArchetypeCatalogFactory(new ArchetypeCatalogFactory.InternalCatalogFactory());
        archetypeManager.addArchetypeCatalogFactory(new ArchetypeCatalogFactory.DefaultLocalCatalogFactory());
        for (ArchetypeCatalogFactory archetypeCatalogFactory : ExtensionReader.readArchetypeExtensions()) {
            archetypeManager.addArchetypeCatalogFactory(archetypeCatalogFactory);
        }
        return archetypeManager;
    }

    @Deprecated
    public PlexusContainer getPlexusContainer() {
        try {
            return this.getMaven().getPlexusContainer();
        }
        catch (CoreException ex) {
            this.getLog().log(ex.getStatus());
            return null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.protocolHandlerService != null) {
            this.protocolHandlerService.unregister();
        }
        context.removeBundleListener(this.bundleListener);
        this.mavenBackgroundJob.cancel();
        try {
            this.mavenBackgroundJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeSaveParticipant("org.eclipse.m2e.core");
        workspace.removeResourceChangeListener((IResourceChangeListener)this.mavenBackgroundJob);
        this.mavenBackgroundJob = null;
        this.projectManager.removeMavenProjectChangedListener(this.configurationManager);
        if (this.indexManager != null) {
            this.projectManager.removeMavenProjectChangedListener(this.indexManager);
        }
        this.projectManager.removeMavenProjectChangedListener(this.repositoryRegistry);
        this.projectManager = null;
        this.toDisposeContainers.forEach(PlexusContainer::dispose);
        this.maven.disposeContainer();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.configurationManager);
        this.configurationManager = null;
        LifecycleMappingFactory.setBundleMetadataSources(null);
        this.projectConversionManager = null;
        plugin = null;
    }

    public static MavenPluginActivator getDefault() {
        return plugin;
    }

    public MavenModelManager getMavenModelManager() {
        return this.modelManager;
    }

    public MavenProjectManager getMavenProjectManager() {
        return this.projectManager;
    }

    public ProjectRegistryManager getMavenProjectManagerImpl() {
        return this.managerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NexusIndexManager getIndexManager() {
        MavenPluginActivator mavenPluginActivator = this;
        synchronized (mavenPluginActivator) {
            if (this.indexManager == null) {
                try {
                    DefaultPlexusContainer indexerContainer = this.newPlexusContainer(IndexUpdater.class.getClassLoader());
                    this.toDisposeContainers.add((PlexusContainer)indexerContainer);
                    this.indexManager = new NexusIndexManager((PlexusContainer)indexerContainer, this.getMavenProjectManager(), this.getRepositoryRegistry(), this.getStateLocation().toFile());
                    this.getMavenProjectManager().addMavenProjectChangedListener(this.indexManager);
                    this.getMaven().addLocalRepositoryListener(new IndexingTransferListener(this.indexManager));
                    ((RepositoryRegistry)this.getRepositoryRegistry()).addRepositoryIndexer(this.indexManager);
                    ((RepositoryRegistry)this.getRepositoryRegistry()).addRepositoryDiscoverer(new IndexesExtensionReader(this.indexManager));
                }
                catch (PlexusContainerException ex1) {
                    this.log.error("Failed to initialize the NexusIndexManager", (Throwable)ex1);
                }
            }
        }
        return this.indexManager;
    }

    public MavenRuntimeManagerImpl getMavenRuntimeManager() {
        return this.runtimeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchetypeManager getArchetypeManager() {
        MavenPluginActivator mavenPluginActivator = this;
        synchronized (mavenPluginActivator) {
            if (this.archetypeManager == null) {
                try {
                    DefaultPlexusContainer archetyperContainer = this.newPlexusContainer(ArchetypeGenerationRequest.class.getClassLoader());
                    this.archetypeManager = MavenPluginActivator.newArchetypeManager((PlexusContainer)archetyperContainer, this.getStateLocation().toFile());
                    try {
                        this.archetypeManager.readCatalogs();
                    }
                    catch (Exception ex) {
                        String msg = "Can't read archetype catalog configuration";
                        this.log.error(msg, (Throwable)ex);
                    }
                }
                catch (PlexusContainerException ex1) {
                    this.log.error("Failed to initialize the ArchetypeManager", (Throwable)ex1);
                }
            }
        }
        return this.archetypeManager;
    }

    public IMavenMarkerManager getMavenMarkerManager() {
        return this.mavenMarkerManager;
    }

    public IMavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public IProjectConfigurationManager getProjectConfigurationManager() {
        return this.configurationManager;
    }

    public ProjectRegistryRefreshJob getProjectManagerRefreshJob() {
        return this.mavenBackgroundJob;
    }

    public static String getVersion() {
        return MavenPluginActivator.plugin.version;
    }

    public static String getQualifiedVersion() {
        return MavenPluginActivator.plugin.qualifiedVersion;
    }

    public static String getUserAgent() {
        String osgiVersion = (String)Platform.getBundle((String)"org.eclipse.osgi").getHeaders().get("Bundle-Version");
        String m2eVersion = MavenPluginActivator.plugin.qualifiedVersion;
        String javaVersion = System.getProperty("java.version", "unknown");
        return "m2e/" + osgiVersion + "/" + m2eVersion + "/" + javaVersion;
    }

    public IRepositoryRegistry getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    public ArchetypeDataSource getArchetypeDataSource(String hint) {
        return this.getArchetypeManager().getArchetypeDataSource(hint);
    }

    public ArchetypeArtifactManager getArchetypeArtifactManager() {
        return this.getArchetypeManager().getArchetypeArtifactManager();
    }

    public WagonManager getWagonManager() {
        return this.maven.lookupComponent(WagonManager.class);
    }

    public ArtifactFactory getArtifactFactory() {
        return this.maven.lookupComponent(ArtifactFactory.class);
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.maven.lookupComponent(ArtifactMetadataSource.class);
    }

    public ArtifactCollector getArtifactCollector() {
        return this.maven.lookupComponent(ArtifactCollector.class);
    }

    public RepositorySystem getRepositorySystem() {
        return this.maven.lookupComponent(RepositorySystem.class);
    }

    public MavenSession setSession(MavenSession session) {
        LegacySupport legacy = this.maven.lookupComponent(LegacySupport.class);
        MavenSession old = legacy.getSession();
        legacy.setSession(session);
        return old;
    }

    public ArtifactFilterManager getArifactFilterManager() {
        return this.artifactFilterManager;
    }

    public IProjectConversionManager getProjectConversionManager() {
        return this.projectConversionManager;
    }

    public IWorkspaceClassifierResolverManager getWorkspaceClassifierResolverManager() {
        return this.workspaceClassifierResolverManager;
    }
}

