/*
 * generated by Xtext 2.17.0
 */
package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.dot.internal.language.rect.Rect;
import org.eclipse.gef.dot.internal.language.rect.RectPackage;
import org.eclipse.gef.dot.internal.language.services.DotRectGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class DotRectSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotRectGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == RectPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case RectPackage.RECT:
				sequence_Rect(context, (Rect) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Rect returns Rect
	 *
	 * Constraint:
	 *     (llx=DOUBLE lly=DOUBLE urx=DOUBLE ury=DOUBLE)
	 */
	protected void sequence_Rect(ISerializationContext context, Rect semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, RectPackage.Literals.RECT__LLX) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, RectPackage.Literals.RECT__LLX));
			if (transientValues.isValueTransient(semanticObject, RectPackage.Literals.RECT__LLY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, RectPackage.Literals.RECT__LLY));
			if (transientValues.isValueTransient(semanticObject, RectPackage.Literals.RECT__URX) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, RectPackage.Literals.RECT__URX));
			if (transientValues.isValueTransient(semanticObject, RectPackage.Literals.RECT__URY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, RectPackage.Literals.RECT__URY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRectAccess().getLlxDOUBLETerminalRuleCall_0_0(), semanticObject.getLlx());
		feeder.accept(grammarAccess.getRectAccess().getLlyDOUBLETerminalRuleCall_2_0(), semanticObject.getLly());
		feeder.accept(grammarAccess.getRectAccess().getUrxDOUBLETerminalRuleCall_4_0(), semanticObject.getUrx());
		feeder.accept(grammarAccess.getRectAccess().getUryDOUBLETerminalRuleCall_6_0(), semanticObject.getUry());
		feeder.finish();
	}
	
	
}
