/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.scripting.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.te.tcf.core.scripting.parser.Token;

public class Parser {
    private final String script;
    private static final Pattern EMPTY_LINE = Pattern.compile("\\s*");
    private static final Pattern COMMENT_LINE = Pattern.compile("\\s*#.*");
    private static final Pattern CONNECT_LINE = Pattern.compile("\\s*connect\\s+.*");
    private static final Pattern COMMAND_LINE = Pattern.compile("\\s*tcf\\s+(\\w+)\\s+(\\w+)(.*)");

    public Parser(String script) {
        Assert.isNotNull((Object)script);
        this.script = script;
    }

    public Token[] parse() throws IOException {
        String line;
        ArrayList<Token> tokens = new ArrayList<Token>();
        BufferedReader reader = new BufferedReader(new StringReader(this.script));
        while ((line = reader.readLine()) != null) {
            Matcher matcher;
            if (EMPTY_LINE.matcher(line).matches() || COMMENT_LINE.matcher(line).matches() || CONNECT_LINE.matcher(line).matches() || !(matcher = COMMAND_LINE.matcher(line)).matches()) continue;
            String serviceName = matcher.group(1).trim();
            String commandName = matcher.group(2).trim();
            String arguments = matcher.group(3);
            Token token = new Token();
            token.setServiceName(serviceName);
            token.setCommandName(commandName);
            this.parseArguments(token, arguments);
            tokens.add(token);
        }
        reader.close();
        return tokens.toArray(new Token[tokens.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected void parseArguments(Token token, String arguments) {
        Assert.isNotNull((Object)token);
        if (arguments == null || "".equals(arguments.trim())) {
            return;
        }
        tokenizer = new StringTokenizer(arguments, " ");
        while (tokenizer.hasMoreTokens()) {
            block32: {
                tok = tokenizer.nextToken();
                if ("".equals(tok.trim())) continue;
                if (tok.equals("null")) {
                    token.addArgument(null);
                    continue;
                }
                if (tok.startsWith("\"")) {
                    fullTok = new StringBuilder(tok);
                    complete = this.isComplete(fullTok.toString(), '\"', '\"');
                    while (!complete && tokenizer.hasMoreTokens()) {
                        fullTok.append(" ");
                        fullTok.append(tokenizer.nextToken());
                        complete = this.isComplete(fullTok.toString(), '\"', '\"');
                    }
                    if (complete) {
                        fullTokStr = fullTok.toString().trim();
                        if (fullTokStr.startsWith("\"")) {
                            fullTokStr = fullTokStr.substring(1);
                        }
                        if (fullTokStr.endsWith("\"")) {
                            fullTokStr = fullTokStr.substring(0, fullTok.length() - 2);
                        }
                        token.addArgument(fullTokStr);
                        continue;
                    }
                }
                if ("true".equalsIgnoreCase(tok) || "false".equalsIgnoreCase(tok)) {
                    token.addArgument(Boolean.valueOf(tok));
                    continue;
                }
                try {
                    i = Integer.decode(tok);
                    token.addArgument(i);
                    continue;
                }
                catch (NumberFormatException v0) {
                    try {
                        l = Long.decode(tok);
                        token.addArgument(l);
                        continue;
                    }
                    catch (NumberFormatException v1) {
                        try {
                            f = Float.valueOf(tok);
                            token.addArgument(f);
                            continue;
                        }
                        catch (NumberFormatException v2) {
                            try {
                                d = Double.valueOf(tok);
                                token.addArgument(d);
                                continue;
                            }
                            catch (NumberFormatException v3) {
                                if (!tok.startsWith("{")) break block32;
                                fullTok = new StringBuilder(tok);
                                complete = this.isComplete(fullTok.toString(), '{', '}');
                                ** while (!complete && tokenizer.hasMoreTokens())
                            }
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    fullTok.append(" ");
                    fullTok.append(tokenizer.nextToken());
                    complete = this.isComplete(fullTok.toString(), '{', '}');
                    continue;
                }
lbl62:
                // 1 sources

                if (complete) {
                    fullTokStr = String.valueOf(fullTok.toString()) + "\u0000";
                    try {
                        args = JSON.parseSequence((byte[])fullTokStr.getBytes());
                        if (args != null) {
                            var12_13 = args;
                            var11_12 = args.length;
                            var10_11 = 0;
                            while (var10_11 < var11_12) {
                                arg = var12_13[var10_11];
                                if (arg != null) {
                                    token.addArgument(arg);
                                }
                                ++var10_11;
                            }
                            continue;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (tok.startsWith("[")) {
                fullTok = new StringBuilder(tok);
                complete = this.isComplete(fullTok.toString(), '[', ']');
                while (!complete && tokenizer.hasMoreTokens()) {
                    fullTok.append(" ");
                    fullTok.append(tokenizer.nextToken());
                    complete = this.isComplete(fullTok.toString(), '[', ']');
                }
                if (complete) {
                    fullTokStr = String.valueOf(fullTok.toString()) + "\u0000";
                    try {
                        args = JSON.parseSequence((byte[])fullTokStr.getBytes());
                        if (args != null) {
                            var12_13 = args;
                            var11_12 = args.length;
                            var10_11 = 0;
                            while (var10_11 < var11_12) {
                                arg = var12_13[var10_11];
                                if (arg != null) {
                                    token.addArgument(arg);
                                }
                                ++var10_11;
                            }
                            continue;
                        }
                    }
                    catch (IOException v4) {}
                }
            }
            token.addArgument(tok);
        }
    }

    protected boolean isComplete(String tok, char opening, char closing) {
        Assert.isNotNull((Object)tok);
        int countOpening = 0;
        int countClosing = 0;
        boolean same = opening == closing;
        int i = 0;
        while (i < tok.length()) {
            char c = tok.charAt(i);
            if (c == opening && same) {
                if (countOpening > countClosing) {
                    ++countClosing;
                } else {
                    ++countOpening;
                }
            } else if (c == opening) {
                ++countOpening;
            } else if (c == closing) {
                ++countClosing;
            }
            ++i;
        }
        return countOpening > 0 && countOpening == countClosing;
    }
}

