/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.jobs.IJob;

public abstract class AbstractJob
implements IJob {
    protected boolean isCancelled = false;
    private String savedName;

    @Override
    public boolean belongsTo(String jobFamily) {
        return false;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public void ensureReadyToRun() {
    }

    protected abstract String getName();

    protected void log(Object message) {
        System.out.println(String.valueOf('[') + this.toString() + "] " + message);
    }

    private final String getShortClassName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        String shortClassName = this.getShortClassName();
        if (this.savedName == null) {
            try {
                this.savedName = this.getName();
            }
            catch (Exception exception) {
                this.savedName = "<Unknown>";
            }
        }
        return String.valueOf(shortClassName) + '|' + this.savedName;
    }

    @Override
    public final boolean execute(IProgressMonitor monitor) {
        try {
            this.run();
        }
        catch (Exception e) {
            RcpttPlugin.log(String.valueOf(this.toString()) + " error", e);
            return false;
        }
        return true;
    }

    protected abstract void run() throws CoreException, IOException;
}

