/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.ChangeSet;

public class DiffChangeSet
extends ChangeSet {
    private final ResourceDiffTree tree = new ResourceDiffTree();

    public DiffChangeSet() {
    }

    public DiffChangeSet(String name) {
        super(name);
    }

    public IResourceDiffTree getDiffTree() {
        return this.tree;
    }

    protected ResourceDiffTree internalGetDiffTree() {
        return this.tree;
    }

    @Override
    public IResource[] getResources() {
        return this.tree.getAffectedResources();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean contains(IResource local) {
        return this.tree.getDiff(local) != null;
    }

    public void add(IDiff diff) {
        if (this.isValidChange(diff)) {
            this.tree.add(diff);
        }
    }

    protected boolean isValidChange(IDiff diff) {
        return diff != null;
    }

    public void add(IDiff[] diffs) {
        try {
            this.tree.beginInput();
            IDiff[] iDiffArray = diffs;
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff diff = iDiffArray[n2];
                this.add(diff);
                ++n2;
            }
        }
        finally {
            this.tree.endInput(null);
        }
    }

    @Override
    public void remove(IResource resource) {
        if (this.contains(resource)) {
            this.tree.remove(resource);
        }
    }

    @Override
    public void rootRemoved(IResource resource, int depth) {
        IDiff[] diffs = this.tree.getDiffs(resource, depth);
        if (diffs.length > 0) {
            try {
                this.tree.beginInput();
                IDiff[] iDiffArray = diffs;
                int n = diffs.length;
                int n2 = 0;
                while (n2 < n) {
                    IDiff diff = iDiffArray[n2];
                    IResource r = this.tree.getResource(diff);
                    if (r != null) {
                        this.tree.remove(r);
                    }
                    ++n2;
                }
            }
            finally {
                this.tree.endInput(null);
            }
        }
    }

    public boolean contains(IPath path) {
        return this.getDiffTree().getDiff(path) != null;
    }

    @Override
    public boolean containsChildren(IResource resource, int depth) {
        return this.getDiffTree().getDiffs(resource, depth).length > 0;
    }

    public void remove(IPath[] paths) {
        try {
            this.tree.beginInput();
            IPath[] iPathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                this.tree.remove(path);
                ++n2;
            }
        }
        finally {
            this.tree.endInput(null);
        }
    }

    @Override
    public void remove(IResource[] resources) {
        try {
            this.tree.beginInput();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                this.tree.remove(resource);
                ++n2;
            }
        }
        finally {
            this.tree.endInput(null);
        }
    }

    @Override
    public String getComment() {
        return null;
    }
}

